/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import org.apache.commons.lang.StringUtils;
import org.jboss.el.lang.FunctionMapperImpl;
import org.jboss.seam.el.EL;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.actions.seam.SeamActionContext;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PageProvider", category="Fetch", label="PageProvider", description="Perform a query or a named provider query on the repository. Result is paginated. The query result will become the input for the next operation. If no query or provider name is given, a query returning all the documents that the user has access to will be executed.")
public class DocumentPageProviderOperation {
    public static final String ID = "Document.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    private static final String SORT_PARAMETER_SEPARATOR = " ";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService ppService;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Deprecated
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    @Deprecated
    protected Integer page;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Deprecated
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", alias={"searchTerm"}, required=false)
    protected StringList strParameters;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;
    @Param(name="maxResults", required=false)
    protected String maxResults = "100";
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected String sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected String sortOrder;

    @OperationMethod
    public PaginableDocumentModelListImpl run() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        ArrayList<SortInfo> sortInfos = null;
        if (this.sortInfoAsStringList != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(SORT_PARAMETER_SEPARATOR)) {
                    String[] parts = sortInfoDesc.split(SORT_PARAMETER_SEPARATOR);
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        } else if (!StringUtils.isBlank((String)this.sortBy)) {
            sortInfos = new ArrayList();
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((String)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && (this.providerName == null || this.providerName.length() == 0)) {
            this.query = "SELECT * from Document";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        if (this.currentPageIndex != null) {
            targetPage = this.currentPageIndex.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        SimpleDocumentModel searchDocumentModel = null;
        if (this.namedParameters != null && !this.namedParameters.isEmpty()) {
            searchDocumentModel = new SimpleDocumentModel();
            searchDocumentModel.putContextData("namedParameters", (Serializable)this.namedParameters);
        }
        if (this.query != null) {
            CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
            desc.setPattern(this.query);
            if (this.maxResults != null && !this.maxResults.isEmpty() && !this.maxResults.equals("-1")) {
                desc.getProperties().put("maxResults", this.maxResults);
            }
            return new PaginableDocumentModelListImpl(pps.getPageProvider("", (PageProviderDefinition)desc, (DocumentModel)searchDocumentModel, sortInfos, targetPageSize, targetPage, props, parameters), this.documentLinkBuilder);
        }
        return new PaginableDocumentModelListImpl(pps.getPageProvider(this.providerName, (DocumentModel)searchDocumentModel, sortInfos, targetPageSize, targetPage, props, this.context.containsKey((Object)"seamActionContext") ? this.getParameters(this.providerName, parameters) : parameters), this.documentLinkBuilder);
    }

    private Object[] getParameters(String pageProviderName, Object[] givenParameters) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderDefinition ppDef = this.ppService.getPageProviderDefinition(pageProviderName);
        String[] params = ppDef.getQueryParameters();
        if (params == null) {
            params = new String[]{};
        }
        Object[] resolvedParams = new Object[params.length + (givenParameters != null ? givenParameters.length : 0)];
        ELContext elContext = EL.createELContext((ELResolver)SeamActionContext.EL_RESOLVER, (FunctionMapper)new FunctionMapperImpl());
        int i = 0;
        if (givenParameters != null) {
            i = givenParameters.length;
            System.arraycopy(givenParameters, 0, resolvedParams, 0, i);
        }
        for (int j = 0; j < params.length; ++j) {
            ValueExpression ve = SeamActionContext.EXPRESSION_FACTORY.createValueExpression(elContext, params[j], Object.class);
            resolvedParams[i + j] = ve.getValue(elContext);
        }
        return resolvedParams;
    }
}

