/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.pathsegment;

import java.util.regex.Pattern;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.runtime.api.Framework;

public class PathSegmentServiceDefault
implements PathSegmentService {
    public Pattern stupidRegexp = Pattern.compile("^[- .,;?!:/\\\\'\"]*$");
    public static final String NUXEO_MAX_SEGMENT_SIZE_PROPERTY = "nuxeo.path.segment.maxsize";
    public int maxSize = Integer.parseInt(Framework.getProperty((String)"nuxeo.path.segment.maxsize", (String)"24"));

    @Override
    public String generatePathSegment(DocumentModel doc) throws ClientException {
        return this.generatePathSegment(doc.getTitle());
    }

    @Override
    public String generatePathSegment(String s) throws ClientException {
        if (s == null) {
            s = "";
        }
        if ((s = s.trim()).length() > this.maxSize) {
            s = s.substring(0, this.maxSize).trim();
        }
        s = s.replace('/', '-');
        if (this.stupidRegexp.matcher(s = s.replace('\\', '-')).matches()) {
            return IdUtils.generateStringId();
        }
        return s;
    }
}

