/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ConflictOperationException;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.jaxrs.io.operations.AutomationInfo;
import org.nuxeo.ecm.automation.server.jaxrs.ChainResource;
import org.nuxeo.ecm.automation.server.jaxrs.OperationResource;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/automation")
@WebObject(type="automation")
public class AutomationResource
extends ModuleRoot {
    protected AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);

    @Path(value="/doc")
    public Object getDocPage() {
        return this.newObject("doc", new Object[0]);
    }

    @Path(value="/debug")
    public Object getDebugPage() {
        return this.newObject("debug", new Object[0]);
    }

    @GET
    @Path(value="/files/{uid}")
    public Object getFile(@Context HttpServletRequest request, @PathParam(value="uid") String uid, @QueryParam(value="path") String path) {
        try {
            CoreSession session = SessionFactory.getSession((HttpServletRequest)request);
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(uid));
            Serializable obj = null;
            try {
                obj = doc.getPropertyValue(path);
            }
            catch (PropertyException e) {
                return ResponseHelper.notFound();
            }
            if (obj == null) {
                return ResponseHelper.notFound();
            }
            if (obj instanceof List) {
                List list = (List)((Object)obj);
                if (list.isEmpty()) {
                    return ResponseHelper.notFound();
                }
                if (list.get(0) instanceof Blob) {
                    return ResponseHelper.blobs(list);
                }
            } else if (obj instanceof Blob) {
                return ResponseHelper.blob((Blob)obj);
            }
            return ResponseHelper.notFound();
        }
        catch (Exception e) {
            throw WebException.newException((Throwable)e);
        }
    }

    @GET
    public AutomationInfo doGet() throws OperationException {
        return new AutomationInfo(this.service);
    }

    @POST
    @Path(value="/login")
    public Object login(@Context HttpServletRequest request) {
        Principal p = request.getUserPrincipal();
        if (p instanceof NuxeoPrincipal) {
            NuxeoPrincipal np = (NuxeoPrincipal)p;
            List groups = np.getAllGroups();
            HashSet set = new HashSet(groups);
            return new LoginInfo(np.getName(), set, np.isAdministrator());
        }
        return Response.status((int)401).build();
    }

    @Path(value="/{oid}")
    public Object getExecutable(@PathParam(value="oid") String oid) {
        if (oid.startsWith("Chain.")) {
            oid = oid.substring(6);
            return new ChainResource(this.service, oid);
        }
        try {
            OperationType op = this.service.getOperation(oid);
            return new OperationResource(this.service, op);
        }
        catch (Throwable cause) {
            if (cause instanceof ConflictOperationException) {
                return WebException.newException((String)("Failed to invoke operation: " + oid), (Throwable)cause, (int)409);
            }
            if (cause instanceof OperationNotFoundException) {
                return WebException.newException((String)("Failed to invoke operation: " + oid), (Throwable)cause, (int)404);
            }
            return WebException.newException((String)("Failed to invoke operation: " + oid), (Throwable)cause);
        }
    }

    @Path(value="/batch")
    public Object getBatchManager() {
        return this.newObject("batch", new Object[0]);
    }
}

