/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ClientSideStateHelper;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.RequestStateManager;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoServerSideStateHelper;

public class NuxeoResponseStateManagerImpl
extends ResponseStateManagerImpl {
    private StateHelper helper;

    public NuxeoResponseStateManagerImpl() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        String stateMode = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod);
        this.helper = "client".equalsIgnoreCase(stateMode) ? new ClientSideStateHelper() : new NuxeoServerSideStateHelper();
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.helper.getCryptographicallyStrongTokenFromSession(context);
    }

    public Object getState(FacesContext context, String viewId) {
        Object state = RequestStateManager.get((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE");
        if (state == null) {
            try {
                state = this.helper.getState(context, viewId);
                if (state != null) {
                    RequestStateManager.set((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE", (Object)state);
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return state;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        this.helper.writeState(context, state, null);
    }

    public String getViewState(FacesContext context, Object state) {
        StringBuilder sb = new StringBuilder(32);
        try {
            this.helper.writeState(context, state, sb);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        return sb.toString();
    }

    public boolean isStateless(FacesContext facesContext, String viewId) {
        return this.helper.isStateless(facesContext, viewId);
    }
}

