/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.faces.application.ViewResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuxeoUnknownResource
extends ViewResource {
    public static final String MARKER = NuxeoUnknownResource.class.getName();
    public static final String PLACEHOLDER = "/facelet_not_found.xhtml";
    private static final Log log = LogFactory.getLog(NuxeoUnknownResource.class);
    protected final String path;
    protected final String errorMessage;

    public NuxeoUnknownResource(String path) {
        this.path = path;
        this.errorMessage = String.format("ERROR: facelet not found at '%s'", path);
    }

    public URL getURL() {
        try {
            String urlPath = String.format("%s%s", MARKER, this.path);
            return new URL("", "", -1, urlPath, new NuxeoNotFoundResourceHandler());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    class NuxeoNotFoundResourceHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            log.error((Object)NuxeoUnknownResource.this.errorMessage);
            return new Connection(url);
        }

        class Connection
        extends URLConnection {
            public Connection(URL url) {
                super(url);
            }

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                String msg = String.format("<span><span style=\"color:red;font-weight:bold;\">%s</span><br /></span>", NuxeoUnknownResource.this.errorMessage);
                return new ByteArrayInputStream(msg.getBytes());
            }
        }
    }
}

