/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.util.MessageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileMimetypeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileSizeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.UIOutputFile;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class UIInputFile
extends UIInput
implements NamingContainer {
    public static final String COMPONENT_TYPE = UIInputFile.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    protected static final String CHOICE_FACET_NAME = "choice";
    protected static final String UPLOAD_FACET_NAME = "upload";
    protected static final String DEFAULT_DOWNLOAD_FACET_NAME = "default_download";
    protected static final String DOWNLOAD_FACET_NAME = "download";
    protected static final String EDIT_FILENAME_FACET_NAME = "edit_filename";
    protected static final Log log = LogFactory.getLog(UIInputFile.class);
    protected String filename;
    protected Boolean editFilename;
    protected String onchange;
    protected String onclick;
    protected String onselect;

    public UIInputFile() {
        FacesContext faces = FacesContext.getCurrentInstance();
        Application app = faces.getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)this, DEFAULT_DOWNLOAD_FACET_NAME, app.createComponent(UIOutputFile.COMPONENT_TYPE));
        ComponentUtils.initiateSubComponent((UIComponent)this, EDIT_FILENAME_FACET_NAME, app.createComponent("javax.faces.HtmlInputText"));
        ComponentUtils.initiateSubComponent((UIComponent)this, UPLOAD_FACET_NAME, app.createComponent("javax.faces.HtmlInputFile"));
    }

    public String getRendererType() {
        return null;
    }

    public Object getValue() {
        Object localValue = this.getLocalValue();
        if (localValue != null) {
            return localValue;
        }
        Blob blob = null;
        Object originalValue = super.getValue();
        String mimeType = null;
        if (originalValue instanceof Blob) {
            blob = (Blob)originalValue;
            mimeType = blob.getMimeType();
        }
        List<InputFileChoice> choices = this.getAvailableChoices(blob, false);
        InputFileChoice choice = choices.get(0);
        return new InputFileInfo((Object)choice, blob, this.getFilename(), mimeType);
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Boolean getEditFilename() {
        if (this.editFilename != null) {
            return this.editFilename;
        }
        ValueExpression ve = this.getValueExpression("editFilename");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setEditFilename(Boolean editFilename) {
        this.editFilename = editFilename;
    }

    public InputFileInfo getFileInfoValue() {
        return (InputFileInfo)this.getValue();
    }

    public InputFileInfo getFileInfoLocalValue() {
        return (InputFileInfo)this.getLocalValue();
    }

    public InputFileInfo getFileInfoSubmittedValue() {
        return (InputFileInfo)this.getSubmittedValue();
    }

    protected String getStringValue(String name, String defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        return this.getStringValue("onchange", null);
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnclick() {
        if (this.onclick != null) {
            return this.onclick;
        }
        return this.getStringValue("onclick", null);
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOnselect() {
        if (this.onselect != null) {
            return this.onselect;
        }
        return this.getStringValue("onselect", null);
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.setValid(true);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        String choice = (String)requestMap.get(radioClientId);
        InputFileInfo submitted = new InputFileInfo(choice, null, null, null);
        this.setSubmittedValue(submitted);
    }

    public void validate(FacesContext context) {
        InputFileChoice choice;
        if (context == null) {
            throw new IllegalArgumentException();
        }
        InputFileInfo submitted = this.getFileInfoSubmittedValue();
        if (submitted == null) {
            return;
        }
        InputFileInfo previous = this.getFileInfoValue();
        try {
            choice = submitted.getConvertedChoice();
        }
        catch (ConverterException ce) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
            this.setValid(false);
            return;
        }
        if (choice == null) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.choiceRequired");
            this.setValid(false);
            return;
        }
        submitted.setChoice((Object)choice);
        InputFileChoice previousChoice = previous.getConvertedChoice();
        boolean temp = InputFileChoice.tempKeep == previousChoice || InputFileChoice.upload == previousChoice;
        List<InputFileChoice> choices = this.getAvailableChoices(previous.getBlob(), temp);
        if (!choices.contains((Object)choice)) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.invalidChoice");
            this.setValid(false);
            return;
        }
        switch (choice) {
            case tempKeep: {
                if (this.isLocalValueSet()) {
                    submitted.setBlob(previous.getConvertedBlob());
                    submitted.setFilename(previous.getConvertedFilename());
                }
                if (!this.getEditFilename().booleanValue()) break;
                this.validateFilename(context, submitted);
                break;
            }
            case keep: {
                submitted.setBlob(previous.getConvertedBlob());
                submitted.setFilename(previous.getConvertedFilename());
                if (!this.getEditFilename().booleanValue()) break;
                this.validateFilename(context, submitted);
                break;
            }
            case upload: {
                try {
                    this.validateBlob(context, submitted);
                    if (!this.isValid()) break;
                    submitted.setChoice((Object)InputFileChoice.tempKeep);
                }
                catch (ValidatorException e) {
                    submitted.setBlob(null);
                    submitted.setFilename(null);
                    submitted.setChoice((Object)InputFileChoice.none);
                }
                break;
            }
            case delete: {
                submitted.setBlob(null);
                submitted.setFilename(null);
                break;
            }
            case none: {
                submitted.setBlob(null);
                submitted.setFilename(null);
            }
        }
        super.validateValue(context, (Object)submitted);
        if (this.isValid()) {
            this.setValue(submitted);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, submitted)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, (Object)previous, (Object)submitted));
            }
        }
    }

    public void validateFilename(FacesContext context, InputFileInfo submitted) {
        UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
        if (filenameFacet instanceof EditableValueHolder) {
            String filename;
            EditableValueHolder filenameComp = (EditableValueHolder)filenameFacet;
            submitted.setFilename(filenameComp.getLocalValue());
            try {
                filename = submitted.getConvertedFilename();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            submitted.setFilename(filename);
        }
    }

    public void validateBlob(FacesContext context, InputFileInfo submitted) throws ValidatorException {
        UIComponent uploadFacet = this.getFacet(UPLOAD_FACET_NAME);
        if (uploadFacet instanceof HtmlInputFile) {
            String filename;
            HtmlInputFile uploadComp = (HtmlInputFile)uploadFacet;
            Object submittedFile = uploadComp.getSubmittedValue();
            if (submittedFile instanceof Part) {
                Part file = (Part)submittedFile;
                try {
                    submitted.setBlob(file.getInputStream());
                }
                catch (IOException e) {
                    ComponentUtils.addErrorMessage(context, (UIComponent)this, e.getMessage());
                    this.setValid(false);
                    return;
                }
                submitted.setFilename(this.retrieveFilename(file));
                submitted.setMimeType(file.getContentType());
            }
            Blob blob = null;
            try {
                blob = submitted.getConvertedBlob();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            if (blob == null) {
                Map requestParameters = context.getExternalContext().getRequestParameterMap();
                String message = requestParameters.containsKey("AJAXREQUEST") ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
                ComponentUtils.addErrorMessage(context, (UIComponent)this, message);
                this.setValid(false);
                return;
            }
            try {
                filename = submitted.getConvertedFilename();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            submitted.setBlob(blob);
            submitted.setFilename(filename);
        }
    }

    protected String retrieveFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return filename;
        }
        return null;
    }

    public void updateFilename(FacesContext context, String newFilename) {
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            ve.setValue(context.getELContext(), (Object)newFilename);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            try {
                InputFileInfo local = this.getFileInfoLocalValue();
                InputFileChoice choice = local.getConvertedChoice();
                if (InputFileChoice.keep == choice && this.getEditFilename().booleanValue() || InputFileChoice.upload == choice || InputFileChoice.delete == choice || InputFileChoice.tempKeep == choice) {
                    // empty if block
                }
                if (InputFileChoice.upload == choice || InputFileChoice.delete == choice || InputFileChoice.tempKeep == choice) {
                    if (InputFileChoice.delete == choice) {
                        ValueExpression vef = this.getValueExpression("filename");
                        if (vef != null) {
                            vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                        }
                        ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                        this.setValue(null);
                        this.setLocalValueSet(false);
                    } else {
                        ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                        this.setValue(null);
                        this.setLocalValueSet(false);
                        ValueExpression vef = this.getValueExpression("filename");
                        if (vef != null) {
                            vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                        }
                    }
                } else if (InputFileChoice.keep == choice) {
                    ValueExpression vef;
                    this.setValue(null);
                    this.setLocalValueSet(false);
                    if (this.getEditFilename().booleanValue() && (vef = this.getValueExpression("filename")) != null) {
                        vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                    }
                }
                return;
            }
            catch (ELException e) {
                String messageStr = e.getMessage();
                for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)});
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)});
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    protected List<InputFileChoice> getAvailableChoices(Object value, boolean temp) {
        ArrayList<InputFileChoice> choices = new ArrayList<InputFileChoice>();
        boolean hasFile = value != null;
        boolean isRequired = this.isRequired();
        if (!hasFile && isRequired) {
            choices.add(InputFileChoice.upload);
        } else if (!hasFile && !isRequired) {
            choices.add(InputFileChoice.none);
            choices.add(InputFileChoice.upload);
        } else if (hasFile && isRequired) {
            if (temp) {
                choices.add(InputFileChoice.tempKeep);
            } else {
                choices.add(InputFileChoice.keep);
            }
            choices.add(InputFileChoice.upload);
        } else if (hasFile && !isRequired) {
            if (temp) {
                choices.add(InputFileChoice.tempKeep);
            } else {
                choices.add(InputFileChoice.keep);
            }
            choices.add(InputFileChoice.upload);
            choices.add(InputFileChoice.delete);
        }
        return choices;
    }

    public Blob getCurrentBlob() {
        Blob blob = null;
        try {
            InputFileInfo submittedFileInfo = this.getFileInfoSubmittedValue();
            if (submittedFileInfo != null) {
                InputFileChoice choice = submittedFileInfo.getConvertedChoice();
                if (InputFileChoice.keep == choice || InputFileChoice.tempKeep == choice) {
                    InputFileInfo fileInfo = this.getFileInfoValue();
                    blob = fileInfo.getConvertedBlob();
                } else {
                    blob = submittedFileInfo.getConvertedBlob();
                }
            } else {
                InputFileInfo fileInfo = this.getFileInfoValue();
                blob = fileInfo.getConvertedBlob();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return blob;
    }

    public String getCurrentFilename() {
        String filename = null;
        try {
            InputFileInfo submittedFileInfo = this.getFileInfoSubmittedValue();
            if (submittedFileInfo != null) {
                InputFileChoice choice = submittedFileInfo.getConvertedChoice();
                if (InputFileChoice.keep == choice || InputFileChoice.tempKeep == choice) {
                    InputFileInfo fileInfo = this.getFileInfoValue();
                    filename = fileInfo.getConvertedFilename();
                } else {
                    filename = submittedFileInfo.getConvertedFilename();
                }
            } else {
                InputFileInfo fileInfo = this.getFileInfoValue();
                filename = fileInfo.getConvertedFilename();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return filename;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        InputFileChoice currentChoice;
        ResponseWriter writer = context.getResponseWriter();
        Blob blob = this.getCurrentBlob();
        String filename = this.getCurrentFilename();
        InputFileInfo fileInfo = this.getFileInfoSubmittedValue();
        if (fileInfo == null) {
            fileInfo = this.getFileInfoValue();
        }
        boolean temp = InputFileChoice.tempKeep == (currentChoice = fileInfo.getConvertedChoice());
        List<InputFileChoice> choices = this.getAvailableChoices(blob, temp);
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        writer.startElement("table", (UIComponent)this);
        writer.writeAttribute("class", (Object)"dataInput", null);
        writer.startElement("tbody", (UIComponent)this);
        writer.writeAttribute("class", this.getAttributes().get("styleClass"), null);
        for (InputFileChoice radioChoice : choices) {
            String onselect;
            String onclick;
            String onchange;
            String id = radioClientId + radioChoice.name();
            writer.startElement("tr", (UIComponent)this);
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"radioColumn", null);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "radio");
            props.put("name", radioClientId);
            props.put("id", id);
            props.put("value", radioChoice.name());
            if (radioChoice == currentChoice) {
                props.put("checked", "checked");
            }
            if ((onchange = this.getOnchange()) != null) {
                props.put("onchange", onchange);
            }
            if ((onclick = this.getOnclick()) != null) {
                props.put("onclick", onclick);
            }
            if ((onselect = this.getOnselect()) != null) {
                props.put("onselect", onselect);
            }
            StringBuffer htmlBuffer = new StringBuffer();
            htmlBuffer.append("<input");
            for (Map.Entry prop : props.entrySet()) {
                htmlBuffer.append(String.format(" %s=\"%s\"", prop.getKey(), prop.getValue()));
            }
            htmlBuffer.append(" />");
            writer.write(htmlBuffer.toString());
            writer.endElement("td");
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"fieldColumn", null);
            String html = "<label for=\"%s\" style=\"float:left\">%s</label>";
            String label = (String)ComponentUtils.getAttributeValue((UIComponent)this, (Object)((Object)radioChoice) + "Label", null);
            if (label == null) {
                label = ComponentUtils.translate(context, "label.inputFile." + (Object)((Object)radioChoice) + "Choice");
            }
            writer.write(String.format(html, id, label));
            writer.write("&#x0020;");
            if (InputFileChoice.keep == radioChoice || InputFileChoice.tempKeep == radioChoice) {
                UIComponent downloadFacet = this.getFacet(DOWNLOAD_FACET_NAME);
                if (downloadFacet != null) {
                    ComponentUtils.encodeComponent(context, downloadFacet);
                } else {
                    downloadFacet = this.getFacet(DEFAULT_DOWNLOAD_FACET_NAME);
                    if (downloadFacet != null) {
                        UIOutputFile downloadComp = (UIOutputFile)downloadFacet;
                        downloadComp.setQueryParent(true);
                        ComponentUtils.copyValues((UIComponent)this, (UIComponent)downloadComp, new String[]{"downloadLabel", "iconRendered"});
                        ComponentUtils.copyLinkValues((UIComponent)this, (UIComponent)downloadComp);
                        ComponentUtils.encodeComponent(context, (UIComponent)downloadComp);
                    }
                }
                if (this.getEditFilename().booleanValue()) {
                    writer.write("<br />");
                    UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
                    if (filenameFacet instanceof HtmlInputText) {
                        HtmlInputText filenameComp = (HtmlInputText)filenameFacet;
                        filenameComp.setValue((Object)filename);
                        filenameComp.setLocalValueSet(false);
                        String onClick = "document.getElementById('%s').checked='checked'";
                        filenameComp.setOnclick(String.format(onClick, id));
                        writer.write("&#x0020;");
                        html = "<label for=\"%s\">%s</label>";
                        label = (String)ComponentUtils.getAttributeValue((UIComponent)this, "editFilenameLabel", null);
                        if (label == null) {
                            label = ComponentUtils.translate(context, "label.inputFile.editFilename");
                        }
                        writer.write(String.format(html, filenameComp.getId(), label));
                        writer.write("&#x0020;");
                        ComponentUtils.encodeComponent(context, (UIComponent)filenameComp);
                    }
                }
            } else if (InputFileChoice.upload == radioChoice) {
                UIComponent uploadFacet;
                long sizeMax = 0L;
                String sizeConstraint = null;
                ArrayList<String> authorizedExtensions = new ArrayList<String>();
                ArrayList<String> unauthorizedExtensions = new ArrayList<String>();
                boolean hidden = false;
                for (Validator val : this.getValidators()) {
                    if (val instanceof InputFileSizeValidator) {
                        InputFileSizeValidator sizeVal = (InputFileSizeValidator)val;
                        long currentSizeMax = sizeVal.getMaxSizeBytes();
                        if (currentSizeMax <= sizeMax) continue;
                        sizeMax = currentSizeMax;
                        sizeConstraint = sizeVal.getMaxSize();
                        continue;
                    }
                    if (!(val instanceof InputFileMimetypeValidator)) continue;
                    InputFileMimetypeValidator extVal = (InputFileMimetypeValidator)val;
                    hidden = extVal.isHidden();
                    if (extVal.isAuthorized()) {
                        authorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
                        continue;
                    }
                    unauthorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
                }
                ArrayList<String> constraints = new ArrayList<String>();
                if (sizeConstraint != null) {
                    constraints.add(ComponentUtils.translate(context, "label.inputFile.maxSize", sizeConstraint));
                }
                if (!(hidden || authorizedExtensions.isEmpty() && unauthorizedExtensions.isEmpty())) {
                    if (!authorizedExtensions.isEmpty()) {
                        constraints.add(ComponentUtils.translate(context, "label.inputFile.authorizedExtensions", StringUtils.join((Object[])authorizedExtensions.toArray(), (String)", ")));
                    }
                    if (!unauthorizedExtensions.isEmpty()) {
                        constraints.add(ComponentUtils.translate(context, "label.inputFile.unauthorizedExtensions", StringUtils.join((Object[])unauthorizedExtensions.toArray(), (String)", ")));
                    }
                }
                if (constraints.size() > 0) {
                    writer.write("(");
                    writer.write(StringUtils.join((Object[])constraints.toArray(), (String)", "));
                    writer.write(")");
                    writer.write("&#x0020;");
                }
                if ((uploadFacet = this.getFacet(UPLOAD_FACET_NAME)) instanceof HtmlInputFile) {
                    HtmlInputFile uploadComp = (HtmlInputFile)uploadFacet;
                    String onClick = "document.getElementById('%s').checked='checked'";
                    uploadComp.setOnclick(String.format(onClick, id));
                    ComponentUtils.encodeComponent(context, (UIComponent)uploadComp);
                }
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.flush();
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.filename, this.editFilename, this.onchange, this.onclick, this.onselect};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.filename = (String)values[1];
        this.editFilename = (Boolean)values[2];
        this.onchange = (String)values[3];
        this.onclick = (String)values[4];
        this.onselect = (String)values[5];
    }
}

