/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.management.ObjectInstance;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.management.jtajca.CoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.Defaults;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.runtime.metrics.MetricsService;

public class DefaultCoreSessionMonitor
implements CoreSessionMonitor {
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected ObjectInstance self;

    @Override
    public int getCount() {
        return CoreInstance.getInstance().getNumberOfSessions();
    }

    @Override
    public String[] getInfos() {
        return this.toInfos(this.toSortedRegistration(CoreInstance.getInstance().getRegistrationInfos()));
    }

    public CoreInstance.RegistrationInfo[] toSortedRegistration(Collection<CoreInstance.RegistrationInfo> infos) {
        CoreInstance.RegistrationInfo[] sortedInfos = infos.toArray(new CoreInstance.RegistrationInfo[infos.size()]);
        Arrays.sort(sortedInfos, new Comparator<CoreInstance.RegistrationInfo>(){

            @Override
            public int compare(CoreInstance.RegistrationInfo o1, CoreInstance.RegistrationInfo o2) {
                return o2.session.getSessionId().compareTo(o1.session.getSessionId());
            }
        });
        return sortedInfos;
    }

    public String[] toInfos(CoreInstance.RegistrationInfo[] infos) {
        String[] values = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            values[i] = Defaults.instance.printStackTrace(infos[i]);
        }
        return values;
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(CoreSessionMonitor.class, this);
        this.registry.register(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{"sessions"}), (Metric)new JmxAttributeGauge(this.self.getObjectName(), "Count"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        this.registry.remove(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{"sessions"}));
        this.self = null;
    }
}

