/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.CoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.Defaults;
import org.nuxeo.ecm.core.management.jtajca.TransactionMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultCoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultTransactionMonitor;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.jtajca.NuxeoContainerListener;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.metrics.MetricsServiceImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DefaultMonitorComponent
extends DefaultComponent {
    private final ConnectionManagerUpdater cmUpdater = new ConnectionManagerUpdater();
    protected final Log log = LogFactory.getLog(DefaultMonitorComponent.class);
    protected CoreSessionMonitor coreSessionMonitor;
    protected TransactionMonitor transactionMonitor;
    protected Map<String, ConnectionPoolMonitor> poolConnectionMonitors = new HashMap<String, ConnectionPoolMonitor>();
    protected boolean installed;

    public void applicationStarted(ComponentContext context) throws Exception {
        this.uninstall();
        this.install();
    }

    public int getApplicationStartedOrder() {
        return ((MetricsServiceImpl)Framework.getRuntime().getComponent(MetricsService.class.getName())).getApplicationStartedOrder() + 1;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.uninstall();
        super.deactivate(context);
    }

    protected void install() throws Exception {
        this.installed = true;
        this.coreSessionMonitor = new DefaultCoreSessionMonitor();
        this.coreSessionMonitor.install();
        this.transactionMonitor = new DefaultTransactionMonitor();
        this.transactionMonitor.install();
        try {
            this.installPoolMonitors();
        }
        catch (ClientException cause) {
            this.log.warn((Object)"Cannot install storage monitors", (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installPoolMonitors() throws ClientException, LoginException {
        NuxeoContainer.addListener((NuxeoContainerListener)this.cmUpdater);
        ClientException errors = new ClientException("Cannot install pool monitors");
        LoginContext loginContext = Framework.login();
        try {
            for (String name : ((RepositoryService)Framework.getLocalService(RepositoryService.class)).getRepositoryNames()) {
                try {
                    CoreSession session = CoreInstance.openCoreSession((String)name);
                    Throwable throwable = null;
                    if (session == null) continue;
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    session.close();
                }
                catch (ClientException cause) {
                    errors.addSuppressed((Throwable)cause);
                }
            }
        }
        finally {
            loginContext.logout();
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateRepository(String repositoryName) throws ClientException {
        block5: {
            CoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);
            Throwable throwable = null;
            if (session == null) break block5;
            if (throwable != null) {
                try {
                    session.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                session.close();
            }
        }
    }

    protected void uninstall() throws JMException {
        if (!this.installed) {
            return;
        }
        this.installed = false;
        NuxeoContainer.removeListener((NuxeoContainerListener)this.cmUpdater);
        for (ConnectionPoolMonitor storage : this.poolConnectionMonitors.values()) {
            storage.uninstall();
        }
        this.coreSessionMonitor.uninstall();
        this.transactionMonitor.uninstall();
        this.poolConnectionMonitors.clear();
        this.coreSessionMonitor = null;
        this.transactionMonitor = null;
    }

    protected static ObjectInstance bind(Object managed) {
        return DefaultMonitorComponent.bind(managed, "default");
    }

    protected static ObjectInstance bind(Class<?> itf, Object managed) {
        return DefaultMonitorComponent.bind(itf, managed, "default");
    }

    protected static ObjectInstance bind(Object managed, String name) {
        return DefaultMonitorComponent.bind(managed.getClass().getInterfaces()[0], managed, name);
    }

    protected static ObjectInstance bind(Class<?> itf, Object managed, String name) {
        MBeanServer mbs = ((ServerLocator)Framework.getLocalService(ServerLocator.class)).lookupServer();
        name = Defaults.instance.name(itf, name);
        try {
            return mbs.registerMBean(managed, new ObjectName(name));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new UnsupportedOperationException("Cannot bind " + managed + " on " + name, e);
        }
    }

    protected static void unbind(ObjectInstance instance) {
        MBeanServer mbs = ((ServerLocator)Framework.getLocalService(ServerLocator.class)).lookupServer();
        try {
            mbs.unregisterMBean(instance.getObjectName());
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            throw new UnsupportedOperationException("Cannot unbind " + instance, e);
        }
    }

    private class ConnectionManagerUpdater
    implements NuxeoContainerListener {
        private ConnectionManagerUpdater() {
        }

        public void handleNewConnectionManager(String name, AbstractConnectionManager cm) {
            DefaultConnectionPoolMonitor monitor = new DefaultConnectionPoolMonitor(name, cm);
            monitor.install();
            DefaultMonitorComponent.this.poolConnectionMonitors.put(name, monitor);
        }

        public void handleConnectionManagerReset(String name, AbstractConnectionManager cm) {
            DefaultConnectionPoolMonitor monitor = (DefaultConnectionPoolMonitor)DefaultMonitorComponent.this.poolConnectionMonitors.get(name);
            monitor.handleNewConnectionManager(cm);
        }

        public void handleConnectionManagerDispose(String name, AbstractConnectionManager mgr) {
            ConnectionPoolMonitor monitor = DefaultMonitorComponent.this.poolConnectionMonitors.remove(name);
            monitor.uninstall();
        }
    }
}

