/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.api.CommentConverter;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.impl.CommentSorter;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CommentManagerImpl
implements CommentManager {
    private static final Log log = LogFactory.getLog(CommentManagerImpl.class);
    final SimpleDateFormat timeFormat = new SimpleDateFormat("dd-HHmmss.S");
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
    final CommentServiceConfig config;
    final CommentConverter commentConverter;
    public static final String COMMENTS_DIRECTORY = "Comments";

    public CommentManagerImpl(CommentServiceConfig config) {
        this.config = config;
        this.commentConverter = config.getCommentConverter();
    }

    private static RelationManager getRelationManager() throws Exception {
        return (RelationManager)Framework.getService(RelationManager.class);
    }

    public List<DocumentModel> getComments(DocumentModel docModel) throws ClientException {
        RelationManager relationManager;
        Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", docModel.getCoreSession());
        try {
            relationManager = CommentManagerImpl.getRelationManager();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        Graph graph = relationManager.getGraphByName(this.config.graphName);
        Resource docResource = relationManager.getResource(this.config.documentNamespace, (Serializable)docModel, ctxMap);
        if (docResource == null) {
            throw new ClientException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
        }
        List statementList = graph.getStatements(null, null, (Node)docResource);
        if (graph instanceof JenaGraph) {
            QNameResourceImpl oldDocResource = new QNameResourceImpl(this.config.documentNamespace, docModel.getId());
            statementList.addAll(graph.getStatements(null, null, (Node)oldDocResource));
        }
        ArrayList<DocumentModel> commentList = new ArrayList<DocumentModel>();
        for (Statement stmt : statementList) {
            QNameResourceImpl subject = (QNameResourceImpl)stmt.getSubject();
            DocumentModel commentDocModel = null;
            try {
                commentDocModel = (DocumentModel)relationManager.getResourceRepresentation(this.config.commentNamespace, (Resource)subject, ctxMap);
            }
            catch (Exception e) {
                log.error((Object)"failed to retrieve commentDocModel from relations");
            }
            if (commentDocModel == null) {
                log.warn((Object)"Could not adapt comment relation subject to a document model; check the service relation adapters configur  ation");
                continue;
            }
            commentList.add(commentDocModel);
        }
        CommentSorter sorter = new CommentSorter(true);
        Collections.sort(commentList, sorter);
        return commentList;
    }

    public DocumentModel createComment(DocumentModel docModel, String comment, String author) throws ClientException {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel commentDM = session.createDocumentModel("Comment");
            commentDM.setPropertyValue("comment:text", (Serializable)((Object)comment));
            commentDM.setPropertyValue("comment:author", (Serializable)((Object)author));
            commentDM.setPropertyValue("comment:creationDate", (Serializable)Calendar.getInstance());
            commentDM = this.internalCreateComment(session, docModel, commentDM, null);
            session.save();
            DocumentModel documentModel = commentDM;
            return documentModel;
        }
    }

    public DocumentModel createComment(DocumentModel docModel, String comment) throws ClientException {
        String author = CommentManagerImpl.getCurrentUser(docModel);
        return this.createComment(docModel, comment, author);
    }

    private static String updateAuthor(DocumentModel docModel, DocumentModel comment) throws ClientException {
        String author = (String)comment.getProperty("comment", "author");
        if (author == null) {
            log.debug((Object)"deprecated use of createComment: the client should set the author property on document");
            author = CommentManagerImpl.getCurrentUser(docModel);
            comment.setProperty("comment", "author", (Object)author);
        }
        return author;
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel comment) throws ClientException {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel doc = this.internalCreateComment(session, docModel, comment, null);
            session.save();
            doc.detach(true);
            DocumentModel documentModel = doc;
            return documentModel;
        }
    }

    protected DocumentModel internalCreateComment(CoreSession session, DocumentModel docModel, DocumentModel comment, String path) throws ClientException {
        DocumentModel createdComment;
        String author = CommentManagerImpl.updateAuthor(docModel, comment);
        try {
            createdComment = this.createCommentDocModel(session, docModel, comment, path);
            RelationManager relationManager = CommentManagerImpl.getRelationManager();
            Resource commentRes = relationManager.getResource(this.config.commentNamespace, (Serializable)createdComment, null);
            Resource documentRes = relationManager.getResource(this.config.documentNamespace, (Serializable)docModel, null);
            if (commentRes == null || documentRes == null) {
                throw new ClientException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
            }
            ResourceImpl predicateRes = new ResourceImpl(this.config.predicateNamespace);
            StatementImpl stmt = new StatementImpl((Node)commentRes, (Node)predicateRes, (Node)documentRes);
            relationManager.getGraphByName(this.config.graphName).add((Statement)stmt);
        }
        catch (Exception e) {
            throw new ClientException("failed to create comment", (Throwable)e);
        }
        NuxeoPrincipal principal = null;
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            if (userManager == null) {
                log.error((Object)"Error notifying comment added: UserManager service is not found");
            } else {
                principal = userManager.getPrincipal(author);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error building principal for notification", (Throwable)e);
        }
        if (principal != null) {
            CommentManagerImpl.notifyEvent(session, docModel, "commentAdded", null, createdComment, principal);
        }
        return createdComment;
    }

    private DocumentModel createCommentDocModel(CoreSession mySession, DocumentModel docModel, DocumentModel comment, String path) throws ClientException {
        PathSegmentService pss;
        CommentManagerImpl.updateAuthor(docModel, comment);
        String[] pathList = this.getCommentPathList(comment);
        String domainPath = path == null ? docModel.getPath().segment(0) : path;
        if (mySession == null) {
            return null;
        }
        DocumentModel parent = mySession.getDocument((DocumentRef)new PathRef(domainPath));
        for (String name : pathList) {
            String pathStr = parent.getPathAsString();
            PathRef ref = new PathRef(pathStr, name);
            if (mySession.exists((DocumentRef)ref)) {
                parent = mySession.getDocument((DocumentRef)ref);
                if (parent.isFolder()) continue;
                throw new ClientException(parent.getPathAsString() + " is not folderish");
            }
            DocumentModel dm = mySession.createDocumentModel(pathStr, name, "HiddenFolder");
            dm.setProperty("dublincore", "title", (Object)name);
            dm.setProperty("dublincore", "description", (Object)"");
            dm.setProperty("dublincore", "created", (Object)Calendar.getInstance());
            dm = mySession.createDocument(dm);
            CommentManagerImpl.setFolderPermissions(dm);
            parent = dm;
        }
        String pathStr = parent.getPathAsString();
        String commentName = this.getCommentName(docModel, comment);
        CommentConverter converter = this.config.getCommentConverter();
        try {
            pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        DocumentModel commentDocModel = mySession.createDocumentModel(comment.getType());
        commentDocModel.setProperty("dublincore", "title", (Object)commentName);
        converter.updateDocumentModel(commentDocModel, comment);
        commentDocModel.setPathInfo(pathStr, pss.generatePathSegment(commentDocModel));
        commentDocModel = mySession.createDocument(commentDocModel);
        CommentManagerImpl.setCommentPermissions(commentDocModel);
        log.debug((Object)("created comment with id=" + commentDocModel.getId()));
        return commentDocModel;
    }

    private static void notifyEvent(CoreSession session, DocumentModel docModel, String eventType, DocumentModel parent, DocumentModel child, NuxeoPrincipal principal) throws ClientException {
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, docModel);
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (parent != null) {
            props.put("parentComment", parent);
        }
        props.put("comment_document", child);
        props.put("comment", (String)child.getProperty("comment", "text"));
        props.put("comment_text", (String)child.getProperty("comment", "text"));
        props.put("category", "commentCategory");
        ctx.setProperties(props);
        Event event = ctx.newEvent(eventType);
        try {
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Error while send message", (Throwable)e);
        }
    }

    private static void setFolderPermissions(DocumentModel dm) {
        ACPImpl acp = new ACPImpl();
        ACE grantAddChildren = new ACE("members", "AddChildren", true);
        ACE grantRemoveChildren = new ACE("members", "RemoveChildren", true);
        ACE grantRemove = new ACE("members", "Remove", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantAddChildren, grantRemoveChildren, grantRemove});
        acp.addACL((ACL)acl);
        try {
            dm.setACP((ACP)acp, true);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private static void setCommentPermissions(DocumentModel dm) {
        ACPImpl acp = new ACPImpl();
        ACE grantRead = new ACE("Everyone", "Read", true);
        ACE grantRemove = new ACE("members", "Remove", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantRead, grantRemove});
        acp.addACL((ACL)acl);
        try {
            dm.setACP((ACP)acp, true);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private String[] getCommentPathList(DocumentModel comment) {
        String[] pathList = new String[]{COMMENTS_DIRECTORY, this.dateFormat.format(CommentManagerImpl.getCommentTimeStamp(comment))};
        return pathList;
    }

    @Deprecated
    private static String getCurrentUser(DocumentModel target) throws ClientException {
        CoreSession userSession = target.getCoreSession();
        if (userSession == null) {
            throw new ClientException("userSession is null, do not invoke this method when the user is not local");
        }
        return userSession.getPrincipal().getName();
    }

    private String getCommentName(DocumentModel target, DocumentModel comment) throws ClientException {
        String author = (String)comment.getProperty("comment", "author");
        if (author == null) {
            author = CommentManagerImpl.getCurrentUser(target);
        }
        Date creationDate = CommentManagerImpl.getCommentTimeStamp(comment);
        return "COMMENT-" + author + '-' + this.timeFormat.format(creationDate.getTime());
    }

    private static Date getCommentTimeStamp(DocumentModel comment) {
        Calendar creationDate;
        try {
            creationDate = (Calendar)comment.getProperty("dublincore", "created");
        }
        catch (ClientException e) {
            creationDate = null;
        }
        if (creationDate == null) {
            creationDate = Calendar.getInstance();
        }
        return creationDate.getTime();
    }

    public void deleteComment(DocumentModel docModel, DocumentModel comment) throws ClientException {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentRef ref = comment.getRef();
            if (!session.exists(ref)) {
                throw new ClientException("Comment Document does not exist: " + comment.getId());
            }
            NuxeoPrincipal author = CommentManagerImpl.getAuthor(comment);
            session.removeDocument(ref);
            CommentManagerImpl.notifyEvent(session, docModel, "commentRemoved", null, comment, author);
            session.save();
        }
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel parent, DocumentModel child) throws ClientException {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            String author = CommentManagerImpl.updateAuthor(docModel, child);
            DocumentModel parentDocModel = session.getDocument(parent.getRef());
            DocumentModel newComment = this.internalCreateComment(session, parentDocModel, child, null);
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            NuxeoPrincipal principal = userManager.getPrincipal(author);
            CommentManagerImpl.notifyEvent(session, docModel, "commentAdded", parent, newComment, principal);
            session.save();
            DocumentModel documentModel = newComment;
            return documentModel;
        }
    }

    private static NuxeoPrincipal getAuthor(DocumentModel docModel) {
        try {
            String[] contributors = (String[])docModel.getProperty("dublincore", "contributors");
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            return userManager.getPrincipal(contributors[0]);
        }
        catch (Exception e) {
            log.error((Object)"Error building principal for comment author", (Throwable)e);
            return null;
        }
    }

    public List<DocumentModel> getComments(DocumentModel docModel, DocumentModel parent) throws ClientException {
        try {
            return this.getComments(parent);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) throws ClientException {
        RelationManager relationManager;
        Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", comment.getCoreSession());
        try {
            relationManager = CommentManagerImpl.getRelationManager();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        Graph graph = relationManager.getGraphByName(this.config.graphName);
        Resource commentResource = relationManager.getResource(this.config.commentNamespace, (Serializable)comment, ctxMap);
        if (commentResource == null) {
            throw new ClientException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
        }
        ResourceImpl predicate = new ResourceImpl(this.config.predicateNamespace);
        List statementList = graph.getStatements((Node)commentResource, (Node)predicate, null);
        if (graph instanceof JenaGraph) {
            QNameResourceImpl oldDocResource = new QNameResourceImpl(this.config.commentNamespace, comment.getId());
            statementList.addAll(graph.getStatements((Node)oldDocResource, (Node)predicate, null));
        }
        ArrayList<DocumentModel> docList = new ArrayList<DocumentModel>();
        for (Statement stmt : statementList) {
            QNameResourceImpl subject = (QNameResourceImpl)stmt.getObject();
            DocumentModel docModel = null;
            try {
                docModel = (DocumentModel)relationManager.getResourceRepresentation(this.config.documentNamespace, (Resource)subject, ctxMap);
            }
            catch (Exception e) {
                log.error((Object)"failed to retrieve documents from relations");
            }
            if (docModel == null) {
                log.warn((Object)"Could not adapt comment relation subject to a document model; check the service relation adapters configuration");
                continue;
            }
            docList.add(docModel);
        }
        return docList;
    }

    public DocumentModel createLocatedComment(DocumentModel docModel, DocumentModel comment, String path) throws ClientException {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel createdComment = this.internalCreateComment(session, docModel, comment, path);
            session.save();
            DocumentModel documentModel = createdComment;
            return documentModel;
        }
    }

    public DocumentModel getThreadForComment(DocumentModel comment) throws ClientException {
        List<DocumentModel> threads = this.getDocumentsForComment(comment);
        if (threads.size() > 0) {
            DocumentModel thread = threads.get(0);
            while (thread.getType().equals("Post") || thread.getType().equals("Comment")) {
                thread = this.getThreadForComment(thread);
            }
            return thread;
        }
        return null;
    }
}

