/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import org.openqa.selenium.WebDriver;

public class IFrameHelper {
    public static final String CONNECT_IFRAME_URL_PATTERN = "/site/connect";
    public static final String CALLBACK_URL_PATTERN = "ConnectCallback";
    public static final String CONNECT_FRAME_NAME = "connectForm";
    public static final int NBTRY = 10;

    public static boolean focusOnConnectFrame(WebDriver driver) {
        return IFrameHelper.focusOnConnectFrame(driver, 10);
    }

    protected static void wait(int nbSeconds) {
        try {
            Thread.sleep(nbSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean focusOnConnectFrame(WebDriver driver, int nbTry) {
        if (driver.getCurrentUrl().contains(CALLBACK_URL_PATTERN) && nbTry > 0) {
            IFrameHelper.wait(1);
            return IFrameHelper.focusOnConnectFrame(driver, nbTry - 1);
        }
        if (!driver.getCurrentUrl().contains(CONNECT_IFRAME_URL_PATTERN)) {
            try {
                driver.switchTo().frame(CONNECT_FRAME_NAME);
                return true;
            }
            catch (Throwable e) {
                if (nbTry > 0) {
                    System.out.println("Retry to find IFrame on page " + driver.getCurrentUrl());
                    IFrameHelper.wait(2);
                    return IFrameHelper.focusOnConnectFrame(driver, nbTry - 1);
                }
                System.out.println("Unable to find IFrame on page " + driver.getCurrentUrl());
                System.out.println(driver.getPageSource());
            }
        }
        return false;
    }

    public static boolean focusOnWizardPage(WebDriver driver) {
        return IFrameHelper.focusOnWizardPage(driver, 10);
    }

    private static boolean focusOnWizardPage(WebDriver driver, int nbTry) {
        if (driver.getCurrentUrl().contains(CALLBACK_URL_PATTERN) && nbTry > 0) {
            IFrameHelper.wait(2);
            return IFrameHelper.focusOnWizardPage(driver, nbTry - 1);
        }
        try {
            driver.switchTo().defaultContent();
            return true;
        }
        catch (Throwable e) {
            if (nbTry > 0) {
                System.out.println("Retry to find top windows on page " + driver.getCurrentUrl());
                IFrameHelper.wait(1);
                return IFrameHelper.focusOnWizardPage(driver, nbTry - 1);
            }
            System.out.println("Unable to find top windows on page " + driver.getCurrentUrl());
            return false;
        }
    }
}

