/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.DefaultAuthenticator;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private Authenticator authenticator;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> requestedCompressors;
    private final boolean checkSaslSupportedMechs;

    public InternalStreamConnectionInitializer(Authenticator authenticator, BsonDocument clientMetadataDocument, List<MongoCompressor> requestedCompressors) {
        this.authenticator = authenticator;
        this.clientMetadataDocument = clientMetadataDocument;
        this.requestedCompressors = Assertions.notNull("requestedCompressors", requestedCompressors);
        this.checkSaslSupportedMechs = authenticator instanceof DefaultAuthenticator;
    }

    @Override
    public InternalConnectionInitializationDescription initialize(InternalConnection internalConnection) {
        Assertions.notNull("internalConnection", internalConnection);
        InternalConnectionInitializationDescription description = this.initializeConnectionDescription(internalConnection);
        this.authenticate(internalConnection, description.getConnectionDescription());
        return this.completeConnectionDescriptionInitialization(internalConnection, description);
    }

    @Override
    public void initializeAsync(InternalConnection internalConnection, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        this.initializeConnectionDescriptionAsync(internalConnection, this.createConnectionDescriptionCallback(internalConnection, callback));
    }

    private SingleResultCallback<InternalConnectionInitializationDescription> createConnectionDescriptionCallback(final InternalConnection internalConnection, final SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        return new SingleResultCallback<InternalConnectionInitializationDescription>(){

            @Override
            public void onResult(final InternalConnectionInitializationDescription description, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (InternalStreamConnectionInitializer.this.authenticator == null || description.getConnectionDescription().getServerType() == ServerType.REPLICA_SET_ARBITER) {
                    InternalStreamConnectionInitializer.this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
                } else {
                    InternalStreamConnectionInitializer.this.authenticator.authenticateAsync(internalConnection, description.getConnectionDescription(), new SingleResultCallback<Void>(){

                        @Override
                        public void onResult(Void result1, Throwable t1) {
                            if (t1 != null) {
                                callback.onResult(null, t1);
                            } else {
                                InternalStreamConnectionInitializer.this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
                            }
                        }
                    });
                }
            }
        };
    }

    private InternalConnectionInitializationDescription initializeConnectionDescription(InternalConnection internalConnection) {
        BsonDocument isMasterResult;
        BsonDocument isMasterCommandDocument = this.createIsMasterCommand(this.authenticator, internalConnection);
        long start = System.nanoTime();
        try {
            isMasterResult = CommandHelper.executeCommand("admin", isMasterCommandDocument, internalConnection);
        }
        catch (MongoException e) {
            if (this.checkSaslSupportedMechs && e.getCode() == 11) {
                MongoCredential credential = this.authenticator.getMongoCredential();
                throw new MongoSecurityException(credential, String.format("Exception authenticating %s", credential), (Throwable)e);
            }
            throw e;
        }
        long elapsedTime = System.nanoTime() - start;
        ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(internalConnection.getDescription().getConnectionId(), isMasterResult);
        ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), isMasterResult, elapsedTime);
        this.setSpeculativeAuthenticateResponse(isMasterResult);
        return new InternalConnectionInitializationDescription(connectionDescription, serverDescription);
    }

    private BsonDocument createIsMasterCommand(Authenticator authenticator, InternalConnection connection) {
        BsonDocument speculativeAuthenticateDocument;
        BsonDocument isMasterCommandDocument = new BsonDocument("ismaster", (BsonValue)new BsonInt32(1));
        if (this.clientMetadataDocument != null) {
            isMasterCommandDocument.append("client", (BsonValue)this.clientMetadataDocument);
        }
        if (!this.requestedCompressors.isEmpty()) {
            BsonArray compressors = new BsonArray();
            for (MongoCompressor cur : this.requestedCompressors) {
                compressors.add((BsonValue)new BsonString(cur.getName()));
            }
            isMasterCommandDocument.append("compression", (BsonValue)compressors);
        }
        if (this.checkSaslSupportedMechs) {
            MongoCredential credential = authenticator.getMongoCredential();
            isMasterCommandDocument.append("saslSupportedMechs", (BsonValue)new BsonString(credential.getSource() + "." + credential.getUserName()));
        }
        if (authenticator instanceof SpeculativeAuthenticator && (speculativeAuthenticateDocument = ((SpeculativeAuthenticator)((Object)authenticator)).createSpeculativeAuthenticateCommand(connection)) != null) {
            isMasterCommandDocument.append("speculativeAuthenticate", (BsonValue)speculativeAuthenticateDocument);
        }
        return isMasterCommandDocument;
    }

    private InternalConnectionInitializationDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, InternalConnectionInitializationDescription description) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            return description;
        }
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", (BsonValue)new BsonInt32(1)), internalConnection), description);
    }

    private void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription) {
        if (this.authenticator != null && connectionDescription.getServerType() != ServerType.REPLICA_SET_ARBITER) {
            this.authenticator.authenticate(internalConnection, connectionDescription);
        }
    }

    private void initializeConnectionDescriptionAsync(final InternalConnection internalConnection, final SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        final long startTime = System.nanoTime();
        CommandHelper.executeCommandAsync("admin", this.createIsMasterCommand(this.authenticator, internalConnection), internalConnection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument isMasterResult, Throwable t) {
                if (t != null) {
                    if (InternalStreamConnectionInitializer.this.checkSaslSupportedMechs && t instanceof MongoException && ((MongoException)t).getCode() == 11) {
                        MongoCredential credential = InternalStreamConnectionInitializer.this.authenticator.getMongoCredential();
                        callback.onResult(null, new MongoSecurityException(credential, String.format("Exception authenticating %s", credential), t));
                    } else {
                        callback.onResult(null, t);
                    }
                } else {
                    ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
                    ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(connectionId, isMasterResult);
                    ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), isMasterResult, System.nanoTime() - startTime);
                    InternalStreamConnectionInitializer.this.setSpeculativeAuthenticateResponse(isMasterResult);
                    callback.onResult(new InternalConnectionInitializationDescription(connectionDescription, serverDescription), null);
                }
            }
        });
    }

    private void setSpeculativeAuthenticateResponse(BsonDocument isMasterResult) {
        if (this.authenticator instanceof SpeculativeAuthenticator) {
            ((SpeculativeAuthenticator)((Object)this.authenticator)).setSpeculativeAuthenticateResponse(isMasterResult.getDocument((Object)"speculativeAuthenticate", null));
        }
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, final InternalConnectionInitializationDescription description, final SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            callback.onResult(description, null);
            return;
        }
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", (BsonValue)new BsonInt32(1)), internalConnection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(description, null);
                } else {
                    callback.onResult(InternalStreamConnectionInitializer.this.applyGetLastErrorResult(result, description), null);
                }
            }
        });
    }

    private InternalConnectionInitializationDescription applyGetLastErrorResult(BsonDocument getLastErrorResult, InternalConnectionInitializationDescription description) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        ConnectionId connectionId = getLastErrorResult.containsKey((Object)"connectionId") ? connectionDescription.getConnectionId().withServerValue(getLastErrorResult.getNumber((Object)"connectionId").intValue()) : connectionDescription.getConnectionId();
        return description.withConnectionDescription(connectionDescription.withConnectionId(connectionId));
    }
}

