/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.ScheduledReporter;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.stream.StreamService;

public class StreamMetricsReporter
extends ScheduledReporter {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected String hostIp;
    protected String hostname;
    protected String nodeId;

    public StreamMetricsReporter(MetricRegistry registry, MetricFilter filter) {
        super(registry, "stream-reporter", filter, TimeUnit.SECONDS, TimeUnit.SECONDS);
        try {
            InetAddress host = InetAddress.getLocalHost();
            this.hostIp = host.getHostAddress();
            this.hostname = host.getHostName();
        }
        catch (UnknownHostException e) {
            this.hostIp = "unknown";
            this.hostname = "unknown";
        }
    }

    protected String getNodeId() {
        ClusterService clusterService;
        if (this.nodeId == null && (clusterService = (ClusterService)Framework.getService(ClusterService.class)).isEnabled()) {
            this.nodeId = clusterService.getNodeId();
        }
        return this.nodeId;
    }

    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        StreamService service = (StreamService)Framework.getService(StreamService.class);
        if (service == null) {
            return;
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        ArrayNode metrics = OBJECT_MAPPER.createArrayNode();
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(metrics, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<MetricName, Gauge> entry : timers.entrySet()) {
            this.reportTimer(metrics, entry.getKey(), (Timer)entry.getValue());
        }
        for (Map.Entry<MetricName, Gauge> entry : counters.entrySet()) {
            this.reportCounter(metrics, entry.getKey(), (Counter)entry.getValue());
        }
        ObjectNode ret = OBJECT_MAPPER.createObjectNode();
        ret.put("timestamp", timestamp);
        ret.put("hostname", this.hostname);
        ret.put("ip", this.hostIp);
        ret.put("nodeId", this.getNodeId());
        ret.set("metrics", (JsonNode)metrics);
        try {
            service.getStreamManager().append("internal/metrics", Record.of((String)this.hostIp, (byte[])OBJECT_MAPPER.writer().writeValueAsString((Object)ret).getBytes(StandardCharsets.UTF_8)));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new StreamRuntimeException("Cannot convert to json", (Throwable)jsonProcessingException);
        }
    }

    protected void reportTimer(ArrayNode metrics, MetricName key, Timer value) {
        ObjectNode metric = OBJECT_MAPPER.createObjectNode();
        metric.put("k", key.getKey());
        key.getTags().forEach((arg_0, arg_1) -> ((ObjectNode)metric).put(arg_0, arg_1));
        if (value.getCount() == 0L) {
            metric.put("count", 0);
        } else {
            metric.put("count", value.getCount());
            metric.put("rate1m", value.getOneMinuteRate());
            metric.put("rate5m", value.getFiveMinuteRate());
            metric.put("sum", value.getSum());
            Snapshot snapshot = value.getSnapshot();
            metric.put("max", this.convertDuration(snapshot.getMax()));
            metric.put("mean", this.convertDuration(snapshot.getMean()));
            metric.put("min", this.convertDuration(snapshot.getMin()));
            metric.put("stddev", this.convertDuration(snapshot.getStdDev()));
            metric.put("p50", this.convertDuration(snapshot.getMedian()));
            metric.put("p95", this.convertDuration(snapshot.get95thPercentile()));
            metric.put("p99", this.convertDuration(snapshot.get99thPercentile()));
        }
        metrics.add((JsonNode)metric);
    }

    protected void reportCounter(ArrayNode metrics, MetricName key, Counter value) {
        ObjectNode metric = OBJECT_MAPPER.createObjectNode();
        metric.put("k", key.getKey());
        key.getTags().forEach((arg_0, arg_1) -> ((ObjectNode)metric).put(arg_0, arg_1));
        metric.put("v", value.getCount());
        metrics.add((JsonNode)metric);
    }

    protected void reportGauge(ArrayNode metrics, MetricName key, Gauge<?> value) {
        ObjectNode metric = OBJECT_MAPPER.createObjectNode();
        metric.put("k", key.getKey());
        key.getTags().forEach((arg_0, arg_1) -> ((ObjectNode)metric).put(arg_0, arg_1));
        this.putGaugeMetric(metric, value.getValue());
        metrics.add((JsonNode)metric);
    }

    protected void putGaugeMetric(ObjectNode metric, Object o) {
        if (o instanceof Float) {
            metric.put("v", (Float)o);
        } else if (o instanceof Double) {
            metric.put("v", (Double)o);
        } else if (o instanceof Byte) {
            metric.put("v", ((Byte)o).intValue());
        } else if (o instanceof Short) {
            metric.put("v", (Short)o);
        } else if (o instanceof Integer) {
            metric.put("v", (Integer)o);
        } else if (o instanceof Long) {
            metric.put("v", (Long)o);
        } else if (o instanceof BigInteger) {
            metric.put("v", (BigInteger)o);
        } else if (o instanceof BigDecimal) {
            metric.put("v", (BigDecimal)o);
        } else if (o instanceof Boolean) {
            metric.put("v", (Boolean)o != false ? 1 : 0);
        }
    }
}

