/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItemImpl;

@Operation(id="Task.GetAssigned", category="Services", label="Get user tasks", since="5.4", description="List tasks assigned to this user or one of its group.Task properties are serialized using JSON and returned in a Blob.", aliases={"Workflow.GetTask"})
public class GetUserTasks {
    public static final String ID = "Task.GetAssigned";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession repo;
    @Context
    protected TaskService taskService;

    @OperationMethod
    public Blob run() throws IOException {
        List tasks = this.taskService.getCurrentTaskInstances(this.repo);
        if (tasks == null) {
            return null;
        }
        ArrayList<Map> rows = new ArrayList<Map>();
        for (Task task : tasks) {
            DocumentModel doc = this.taskService.getTargetDocumentModel(task, this.repo);
            if (doc == null) {
                log.warn((Object)String.format("User '%s' has a task of type '%s' on an unexisting or invisible document", this.ctx.getPrincipal().getName(), task.getName()));
                continue;
            }
            DashBoardItemImpl item = new DashBoardItemImpl(task, doc, null);
            Map obj = item.asMap();
            rows.add(obj);
        }
        return Blobs.createJSONBlobFromValue(rows);
    }
}

