/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class BatchProcessorWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BatchProcessorWork.class);

    public BatchProcessorWork(String repositoryName, List<String> docIds, String originatingUsername) {
        this.setDocuments(repositoryName, docIds);
        this.setOriginatingUsername(originatingUsername);
    }

    public int getRetryCount() {
        return 1;
    }

    public abstract int getBatchSize();

    public void work() {
        int size = this.docIds.size();
        int batchSize = this.getBatchSize();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getTitle() + ": Starting processing: " + size + " documents with batch size: " + batchSize));
        }
        this.openSystemSession();
        this.setProgress(new Work.Progress(0L, (long)size));
        this.setStatus("Processing");
        for (int start = 0; start < size; start += batchSize) {
            int end = start + batchSize;
            if (end > size) {
                end = size;
            }
            List<String> batch = this.docIds.subList(start, end);
            this.processBatch(batch);
            this.setProgress(new Work.Progress((long)end, (long)size));
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getTitle() + ": Finished processing for batch of size:" + size));
        }
        this.setStatus("Done");
    }

    public abstract void processBatch(List<String> var1);
}

