/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobDispatcher;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.runtime.api.Framework;

public class DefaultBlobDispatcher
implements BlobDispatcher {
    private static final Log log = LogFactory.getLog(DefaultBlobDispatcher.class);
    protected static final String NAME_DEFAULT = "default";
    protected static final String NAME_RECORDS = "records";
    protected static final String MAIN_BLOB_XPATH = "content";
    protected static final String RECORDS_CLAUSE = "ecm:isRecord=true,blob:xpath=content";
    protected static final Pattern NAME_PATTERN = Pattern.compile("(.*?)(=|!=|<=|<|>=|>|~|\\^)(.*)");
    protected static final String REPOSITORY_NAME = "ecm:repositoryName";
    protected static final String PATH = "ecm:path";
    protected static final String IS_RECORD = "ecm:isRecord";
    protected static final String BLOB_PREFIX = "blob:";
    protected static final String BLOB_NAME = "name";
    protected static final String BLOB_MIME_TYPE = "mime-type";
    protected static final String BLOB_ENCODING = "encoding";
    protected static final String BLOB_DIGEST = "digest";
    protected static final String BLOB_LENGTH = "length";
    protected static final String BLOB_XPATH = "xpath";
    protected boolean useRepositoryName = true;
    protected List<Rule> rules;
    protected Set<String> rulesXPaths;
    protected Set<String> providerIds;
    protected List<String> repositoryNames;
    protected String defaultProviderId;

    @Override
    public void initialize(Map<String, String> properties) {
        this.providerIds = new HashSet<String>();
        this.rulesXPaths = new HashSet<String>();
        this.rules = new ArrayList<Rule>();
        for (Map.Entry<String, String> en : properties.entrySet()) {
            String clausesString = en.getKey();
            String providerId = en.getValue();
            this.providerIds.add(providerId);
            if (clausesString.equals(NAME_RECORDS)) {
                clausesString = RECORDS_CLAUSE;
            }
            if (clausesString.equals(NAME_DEFAULT)) {
                this.defaultProviderId = providerId;
                continue;
            }
            List<Clause> clauses = Arrays.stream(clausesString.split(",")).map(this::getClause).filter(Objects::nonNull).collect(Collectors.toList());
            if (clauses.isEmpty()) continue;
            this.rules.add(new Rule(clauses, providerId));
            clauses.forEach(clause -> this.rulesXPaths.add(clause.xpath));
        }
        this.useRepositoryName = this.providerIds.isEmpty();
        if (!this.useRepositoryName && this.defaultProviderId == null) {
            log.error((Object)"Invalid dispatcher configuration, missing default, configuration will be ignored");
            this.useRepositoryName = true;
        }
    }

    protected Clause getClause(String name) {
        Matcher m = NAME_PATTERN.matcher(name);
        if (m.matches()) {
            Op op;
            String xpath = m.group(1);
            String ops = m.group(2);
            Object value = m.group(3);
            switch (ops) {
                case "=": {
                    op = Op.EQ;
                    break;
                }
                case "!=": {
                    op = Op.NEQ;
                    break;
                }
                case "<": {
                    op = Op.LT;
                    break;
                }
                case "<=": {
                    op = Op.LTE;
                    break;
                }
                case ">": {
                    op = Op.GT;
                    break;
                }
                case ">=": {
                    op = Op.GTE;
                    break;
                }
                case "~": {
                    op = Op.GLOB;
                    value = this.getPatternFromGlob((String)value);
                    break;
                }
                case "^": {
                    op = Op.RE;
                    value = Pattern.compile((String)value);
                    break;
                }
                default: {
                    log.error((Object)("Invalid dispatcher configuration operator: " + ops));
                    return null;
                }
            }
            return new Clause(xpath, op, value);
        }
        log.error((Object)("Invalid dispatcher configuration property name: " + name));
        return null;
    }

    protected Pattern getPatternFromGlob(String glob) {
        String regex = Pattern.quote(glob).replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
        return Pattern.compile(regex);
    }

    @Override
    public Collection<String> getBlobProviderIds() {
        if (this.useRepositoryName) {
            if (this.repositoryNames == null) {
                this.repositoryNames = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepositoryNames();
            }
            return this.repositoryNames;
        }
        return this.providerIds;
    }

    protected String getProviderId(Document doc, Blob blob, String blobXPath) {
        if (this.useRepositoryName) {
            return doc.getRepositoryName();
        }
        block2: for (Rule rule : this.rules) {
            for (Clause clause : rule.clauses) {
                Object value;
                try {
                    value = this.getValue(doc, blob, blobXPath, clause);
                }
                catch (PropertyNotFoundException e) {
                    continue block2;
                }
                if (this.match(value = this.convert(value), clause)) continue;
                continue block2;
            }
            return rule.providerId;
        }
        return this.defaultProviderId;
    }

    protected Object getValue(Document doc, Blob blob, String blobXPath, Clause clause) {
        String xpath = clause.xpath;
        if (xpath.equals(REPOSITORY_NAME)) {
            return doc.getRepositoryName();
        }
        if (xpath.equals(PATH)) {
            return doc.getPath();
        }
        if (xpath.equals(IS_RECORD)) {
            return doc.isRecord();
        }
        if (xpath.startsWith(BLOB_PREFIX)) {
            switch (xpath.substring(BLOB_PREFIX.length())) {
                case "name": {
                    return blob.getFilename();
                }
                case "mime-type": {
                    return blob.getMimeType();
                }
                case "encoding": {
                    return blob.getEncoding();
                }
                case "digest": {
                    return blob.getDigest();
                }
                case "length": {
                    return blob.getLength();
                }
                case "xpath": {
                    return blobXPath;
                }
            }
            log.error((Object)("Invalid dispatcher configuration property name: " + xpath));
            throw new PropertyNotFoundException(xpath);
        }
        try {
            return doc.getValue(xpath);
        }
        catch (PropertyNotFoundException e) {
            return doc.getPropertyValue(xpath);
        }
    }

    protected Object convert(Object value) {
        if (value instanceof Calendar) {
            value = ((Calendar)value).toInstant();
        }
        return value;
    }

    protected boolean match(Object value, Clause clause) {
        switch (clause.op) {
            case EQ: {
                return this.compare(value, clause, true, cmp -> cmp == 0);
            }
            case NEQ: {
                return this.compare(value, clause, true, cmp -> cmp != 0);
            }
            case LT: {
                return this.compare(value, clause, false, cmp -> cmp < 0);
            }
            case LTE: {
                return this.compare(value, clause, false, cmp -> cmp <= 0);
            }
            case GT: {
                return this.compare(value, clause, false, cmp -> cmp > 0);
            }
            case GTE: {
                return this.compare(value, clause, false, cmp -> cmp >= 0);
            }
            case GLOB: 
            case RE: {
                return ((Pattern)clause.value).matcher(String.valueOf(value)).matches();
            }
        }
        throw new AssertionError((Object)"notreached");
    }

    protected boolean compare(Object a, Clause clause, boolean eqneq, IntPredicate predicate) {
        int cmp;
        String b = (String)clause.value;
        if (a == null) {
            if (eqneq) {
                cmp = "null".compareTo(b);
            } else {
                try {
                    cmp = Long.valueOf(0L).compareTo(Long.valueOf(b));
                }
                catch (NumberFormatException e) {
                    try {
                        cmp = Double.valueOf(0.0).compareTo(Double.valueOf(b));
                    }
                    catch (NumberFormatException e2) {
                        cmp = "".compareTo(b);
                    }
                }
            }
        } else if (a instanceof Long) {
            try {
                cmp = ((Long)a).compareTo(Long.valueOf(b));
            }
            catch (NumberFormatException e) {
                if (!eqneq) {
                    return false;
                }
                cmp = 1;
            }
        } else if (a instanceof Double) {
            try {
                cmp = ((Double)a).compareTo(Double.valueOf(b));
            }
            catch (NumberFormatException e) {
                if (!eqneq) {
                    return false;
                }
                cmp = 1;
            }
        } else if (a instanceof Instant) {
            try {
                cmp = ((Instant)a).compareTo(Instant.parse(b));
            }
            catch (DateTimeParseException e) {
                if (!eqneq) {
                    return false;
                }
                cmp = 1;
            }
        } else {
            cmp = String.valueOf(a).compareTo(b);
        }
        return predicate.test(cmp);
    }

    @Override
    public String getBlobProvider(String repositoryName) {
        if (this.useRepositoryName) {
            return repositoryName;
        }
        return this.defaultProviderId;
    }

    @Override
    public BlobDispatcher.BlobDispatch getBlobProvider(Document doc, Blob blob, String xpath) {
        if (this.useRepositoryName) {
            String providerId = doc.getRepositoryName();
            return new BlobDispatcher.BlobDispatch(providerId, false);
        }
        String providerId = this.getProviderId(doc, blob, xpath);
        return new BlobDispatcher.BlobDispatch(providerId, true);
    }

    @Override
    public void notifyChanges(Document doc, Set<String> xpaths) {
        if (this.useRepositoryName) {
            return;
        }
        for (String xpath : this.rulesXPaths) {
            if (!xpaths.contains(xpath)) continue;
            doc.visitBlobs(accessor -> this.checkBlob(doc, (Document.BlobAccessor)accessor));
            return;
        }
    }

    protected void checkBlob(Document doc, Document.BlobAccessor accessor) {
        String expectedProviderId;
        Blob blob = accessor.getBlob();
        if (!(blob instanceof ManagedBlob)) {
            return;
        }
        String xpath = accessor.getXPath();
        ManagedBlob managedBlob = (ManagedBlob)blob;
        String previousProviderId = managedBlob.getProviderId();
        if (previousProviderId.equals(expectedProviderId = this.getProviderId(doc, blob, xpath))) {
            return;
        }
        accessor.setBlob(blob);
        this.deleteBlobIfRecord(previousProviderId, doc, xpath);
    }

    @Override
    public void notifyMakeRecord(Document doc) {
        this.notifyChanges(doc, Collections.singleton(IS_RECORD));
    }

    @Override
    public void notifyAfterCopy(Document doc) {
        this.notifyChanges(doc, Collections.singleton(IS_RECORD));
    }

    @Override
    public void notifyBeforeRemove(Document doc) {
        Blob blob;
        String xpath = MAIN_BLOB_XPATH;
        try {
            blob = (Blob)doc.getValue(xpath);
        }
        catch (PropertyNotFoundException e) {
            return;
        }
        if (!(blob instanceof ManagedBlob)) {
            return;
        }
        String blobProviderId = ((ManagedBlob)blob).getProviderId();
        this.deleteBlobIfRecord(blobProviderId, doc, xpath);
    }

    protected void deleteBlobIfRecord(String blobProviderId, Document doc, String xpath) {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blobProviderId);
        if (blobProvider != null && blobProvider.isRecordMode()) {
            this.checkBlobCanBeDeleted(doc, xpath);
            blobProvider.deleteBlob(new BlobContext(doc, xpath));
        }
    }

    protected void checkBlobCanBeDeleted(Document doc, String xpath) {
        if (MAIN_BLOB_XPATH.equals(xpath) && doc.isUnderRetentionOrLegalHold()) {
            boolean allowDeleteUndeletable = Framework.isBooleanPropertyTrue((String)"org.nuxeo.core.allowDeleteUndeletableDocuments");
            if (allowDeleteUndeletable) {
                return;
            }
            throw new DocumentSecurityException("Cannot remove main blob from document " + doc.getUUID() + ", it is under retention / hold");
        }
    }

    protected static class Rule {
        public final List<Clause> clauses;
        public final String providerId;

        public Rule(List<Clause> clauses, String providerId) {
            this.clauses = clauses;
            this.providerId = providerId;
        }
    }

    protected static class Clause {
        public final String xpath;
        public final Op op;
        public final Object value;

        public Clause(String xpath, Op op, Object value) {
            this.xpath = xpath;
            this.op = op;
            this.value = value;
        }
    }

    protected static enum Op {
        EQ,
        NEQ,
        LT,
        LTE,
        GT,
        GTE,
        GLOB,
        RE;

    }
}

