/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import org.nuxeo.ecm.core.trash.BridgeTrashService;
import org.nuxeo.ecm.core.trash.LifeCycleTrashService;
import org.nuxeo.ecm.core.trash.PropertyTrashService;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TrashServiceImpl
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.trash.TrashService");
    public static final String MIGRATION_ID = "trash-storage";
    public static final String MIGRATION_STATE_LIFECYCLE = "lifecycle";
    public static final String MIGRATION_STATE_PROPERTY = "property";
    public static final String MIGRATION_STEP_LIFECYCLE_TO_PROPERTY = "lifecycle-to-property";
    protected volatile TrashService trashService;

    protected TrashService recomputeTrashService() {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        MigrationService.MigrationStatus status = migrationService.getStatus(MIGRATION_ID);
        if (status == null) {
            throw new IllegalStateException("Unknown migration status for: trash-storage");
        }
        if (status.isRunning()) {
            String step = status.getStep();
            if (MIGRATION_STEP_LIFECYCLE_TO_PROPERTY.equals(step)) {
                return new BridgeTrashService(new LifeCycleTrashService(), new PropertyTrashService());
            }
            throw new IllegalStateException("Unknown migration step: " + step);
        }
        String state = status.getState();
        if (MIGRATION_STATE_LIFECYCLE.equals(state)) {
            return new LifeCycleTrashService();
        }
        if (MIGRATION_STATE_PROPERTY.equals(state)) {
            return new PropertyTrashService();
        }
        throw new IllegalStateException("Unknown migration state: " + state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == TrashServiceImpl.class) {
            return adapter.cast((Object)this);
        }
        if (this.trashService == null) {
            TrashServiceImpl trashServiceImpl = this;
            synchronized (trashServiceImpl) {
                if (this.trashService == null) {
                    this.trashService = this.recomputeTrashService();
                }
            }
        }
        return (T)this.trashService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTrashServiceImplementation() {
        TrashServiceImpl trashServiceImpl = this;
        synchronized (trashServiceImpl) {
            this.trashService = this.recomputeTrashService();
        }
    }
}

