/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort")
public class DiscoveryService
extends AbstractService
implements DiscoveryServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, CmisExtensionType extension, Holder<CmisObjectListType> objects) throws CmisException {
        ObjectList changesList;
        org.apache.chemistry.opencmis.commons.spi.Holder changeLogTokenHolder;
        CmisVersion cmisVersion;
        CmisService service;
        block8: {
            block7: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                changeLogTokenHolder = WSConverter.convertHolder(changeLogToken);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            changesList = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objects != null) {
                objects.value = WSConverter.convert((ObjectList)changesList, (CmisVersion)cmisVersion);
            }
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeLogTokenHolder, changeLogToken);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public CmisObjectListType query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisObjectListType cmisObjectListType;
        ObjectList serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisObjectListType cmisObjectListType2 = null;
                this.closeService(service);
                return cmisObjectListType2;
            }
            serviceResult = service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, (IncludeRelationships)WSConverter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, maxItems, skipCount, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisObjectListType cmisObjectListType3 = null;
            this.closeService(service);
            return cmisObjectListType3;
        }
        try {
            cmisObjectListType = WSConverter.convert((ObjectList)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectListType;
    }
}

