/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.extension.CreationContainerListProvider;
import org.nuxeo.ecm.platform.filemanager.service.extension.CreationContainerListProviderDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporterDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.FolderImporter;
import org.nuxeo.ecm.platform.filemanager.service.extension.FolderImporterDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.UnicityExtension;
import org.nuxeo.ecm.platform.filemanager.service.extension.VersioningDescriptor;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class FileManagerService
extends DefaultComponent
implements FileManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.filemanager.service.FileManagerService");
    public static final String DEFAULT_FOLDER_TYPE_NAME = "Folder";
    public static final String QUERY = "SELECT * FROM Document WHERE file:content/digest = '%s'";
    public static final int MAX = 15;
    public static final String PLUGINS_EP = "plugins";
    public static final String UNICITY_EP = "unicity";
    public static final String VERSIONING_EP = "versioning";
    private static final Logger log = LogManager.getLogger(FileManagerService.class);
    private Map<String, FileImporter> fileImporters;
    private List<FolderImporter> folderImporters;
    private List<CreationContainerListProvider> creationContainerListProviders;
    private List<String> fieldsXPath = new ArrayList<String>();
    private boolean unicityEnabled = false;
    private String digestAlgorithm = "sha-256";
    private boolean computeDigest = false;
    public static final VersioningOption DEF_VERSIONING_OPTION = VersioningOption.MINOR;
    public static final boolean DEF_VERSIONING_AFTER_ADD = false;
    @Deprecated(since="9.1")
    private VersioningOption defaultVersioningOption = DEF_VERSIONING_OPTION;
    @Deprecated(since="9.1")
    private boolean versioningAfterAdd = false;

    public void registerContribution(Object contribution, String xp, ComponentInstance component) {
        if (PLUGINS_EP.equals(xp)) {
            xp = this.computePluginsExtensionPoint(contribution.getClass());
        }
        super.registerContribution(contribution, xp, component);
    }

    public void unregisterContribution(Object contribution, String xp, ComponentInstance component) {
        if (PLUGINS_EP.equals(xp)) {
            xp = this.computePluginsExtensionPoint(contribution.getClass());
        }
        super.unregisterContribution(contribution, xp, component);
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.registerFileImporters();
        this.registerFolderImporters();
        this.registerCreationContainerListProviders();
        this.registerUnicity();
        this.registerVersioning();
    }

    protected void registerFileImporters() {
        String xp = this.computePluginsExtensionPoint(FileImporterDescriptor.class);
        this.fileImporters = this.getDescriptors(xp).stream().map(FileImporterDescriptor.class::cast).map(FileImporterDescriptor::newInstance).collect(Collectors.toMap(FileImporter::getName, Function.identity()));
    }

    protected void registerFolderImporters() {
        String xp = this.computePluginsExtensionPoint(FolderImporterDescriptor.class);
        this.folderImporters = this.getDescriptors(xp).stream().map(FolderImporterDescriptor.class::cast).map(FolderImporterDescriptor::newInstance).collect(Collectors.toList());
    }

    protected void registerCreationContainerListProviders() {
        String xp = this.computePluginsExtensionPoint(CreationContainerListProviderDescriptor.class);
        this.creationContainerListProviders = this.getDescriptors(xp).stream().map(CreationContainerListProviderDescriptor.class::cast).map(CreationContainerListProviderDescriptor::newInstance).collect(Collectors.toList());
    }

    protected void registerUnicity() {
        this.getDescriptors(UNICITY_EP).stream().map(UnicityExtension.class::cast).forEach(unicityExtension -> {
            if (unicityExtension.getAlgo() != null) {
                this.digestAlgorithm = unicityExtension.getAlgo();
            }
            if (unicityExtension.getEnabled() != null) {
                this.unicityEnabled = unicityExtension.getEnabled();
            }
            if (unicityExtension.getFields() != null) {
                this.fieldsXPath = unicityExtension.getFields();
            } else {
                this.fieldsXPath.add("file:content");
            }
            if (unicityExtension.getComputeDigest() != null) {
                this.computeDigest = unicityExtension.getComputeDigest();
            }
        });
    }

    @Deprecated(since="9.1")
    protected void registerVersioning() {
        this.getDescriptors(VERSIONING_EP).stream().map(VersioningDescriptor.class::cast).forEach(versioningDescriptor -> {
            String message = "Extension point 'versioning' has been deprecated and corresponding behavior removed from Nuxeo Platform. Please use versioning policy instead.";
            DeprecationLogger.log((String)message, (String)"9.1");
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message);
            String defver = versioningDescriptor.defaultVersioningOption;
            if (!StringUtils.isBlank((CharSequence)defver)) {
                try {
                    this.defaultVersioningOption = VersioningOption.valueOf((String)defver.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Illegal versioning option: {}, using {} instead", (Object)defver, (Object)DEF_VERSIONING_OPTION);
                    this.defaultVersioningOption = DEF_VERSIONING_OPTION;
                }
            }
            if (versioningDescriptor.versionAfterAdd != null) {
                this.versioningAfterAdd = versioningDescriptor.versionAfterAdd;
            }
        });
    }

    protected String computePluginsExtensionPoint(Class<?> klass) {
        return String.format("%s-%s", PLUGINS_EP, klass.getSimpleName());
    }

    private Blob checkMimeType(Blob blob, String fullname) {
        String filename = FileManagerUtils.fetchFileName(fullname);
        blob = ((MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).updateMimetype(blob, filename, Boolean.valueOf(true));
        return blob;
    }

    @Override
    public DocumentModel createFolder(CoreSession documentManager, String fullname, String path, boolean overwrite) throws IOException {
        if (this.folderImporters.isEmpty()) {
            return this.defaultCreateFolder(documentManager, fullname, path, overwrite);
        }
        FolderImporter folderImporter = this.folderImporters.get(this.folderImporters.size() - 1);
        return folderImporter.create(documentManager, fullname, path, overwrite, (TypeManager)Framework.getService(TypeManager.class));
    }

    @Deprecated(since="9.1")
    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path) {
        return this.defaultCreateFolder(documentManager, fullname, path, true);
    }

    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, boolean overwrite) {
        return this.defaultCreateFolder(documentManager, fullname, path, DEFAULT_FOLDER_TYPE_NAME, true, overwrite);
    }

    @Deprecated(since="9.1")
    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, String containerTypeName, boolean checkAllowedSubTypes) {
        return this.defaultCreateFolder(documentManager, fullname, path, containerTypeName, checkAllowedSubTypes, true);
    }

    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, String containerTypeName, boolean checkAllowedSubTypes, boolean overwrite) {
        DocumentModel docModel;
        String title = FileManagerUtils.fetchFileName(fullname);
        if (overwrite && (docModel = FileManagerUtils.getExistingDocByTitle(documentManager, path, title)) != null) {
            return docModel;
        }
        PathRef containerRef = new PathRef(path);
        if (!documentManager.hasPermission((DocumentRef)containerRef, "ReadProperties") || !documentManager.hasPermission((DocumentRef)containerRef, "AddChildren")) {
            throw new DocumentSecurityException("Not enough rights to create folder");
        }
        DocumentModel container = documentManager.getDocument((DocumentRef)containerRef);
        if (checkAllowedSubTypes && !((TypeManager)Framework.getService(TypeManager.class)).isAllowedSubType(containerTypeName, container.getType(), container)) {
            return null;
        }
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel docModel2 = documentManager.createDocumentModel(containerTypeName);
        docModel2.setProperty("dublincore", "title", (Object)title);
        docModel2.setPathInfo(path, pss.generatePathSegment(docModel2));
        docModel2 = documentManager.createDocument(docModel2);
        documentManager.save();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((DocumentModel)docModel2).getName();
        supplierArray[1] = () -> containerTypeName;
        log.debug("Created container: {} with type {}", supplierArray);
        return docModel2;
    }

    @Override
    public DocumentModel createDocumentFromBlob(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullName) throws IOException {
        return this.createDocumentFromBlob(documentManager, input, path, overwrite, fullName, false);
    }

    @Override
    public DocumentModel createDocumentFromBlob(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullName, boolean noMimeTypeCheck) throws IOException {
        FileImporterContext context = FileImporterContext.builder(documentManager, input, path).overwrite(overwrite).fileName(fullName).mimeTypeCheck(!noMimeTypeCheck).build();
        return this.createOrUpdateDocument(context);
    }

    @Override
    public DocumentModel createOrUpdateDocument(FileImporterContext context) throws IOException {
        Blob blob = context.getBlob();
        if (context.isMimeTypeCheck()) {
            blob = this.checkMimeType(blob, context.getFileName());
        }
        ArrayList<FileImporter> importers = new ArrayList<FileImporter>(this.fileImporters.values());
        Collections.sort(importers);
        String mimeType = blob.getMimeType();
        String normalizedMimeType = ((MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).getMimetypeEntryByMimeType(mimeType).getNormalized();
        for (FileImporter importer : importers) {
            DocumentModel doc;
            if (!this.isImporterAvailable(importer, normalizedMimeType, mimeType, context.isExcludeOneToMany()) || (doc = importer.createOrUpdate(context)) == null) continue;
            return doc;
        }
        return null;
    }

    protected boolean isImporterAvailable(FileImporter importer, String normalizedMimeType, String mimeType, boolean excludeOneToMany) {
        return !(!importer.isEnabled() || importer.isOneToMany() && excludeOneToMany || !importer.matches(normalizedMimeType) && !importer.matches(mimeType));
    }

    @Override
    public DocumentModel updateDocumentFromBlob(CoreSession documentManager, Blob input, String path, String fullName) {
        String filename = FileManagerUtils.fetchFileName(fullName);
        DocumentModel doc = FileManagerUtils.getExistingDocByFileName(documentManager, path, filename);
        if (doc != null) {
            doc.setProperty("file", "content", (Object)input);
            documentManager.saveDocument(doc);
            documentManager.save();
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getName();
            log.debug("Updated the document: {}", supplierArray);
        }
        return doc;
    }

    public FileImporter getPluginByName(String name) {
        return this.fileImporters.get(name);
    }

    @Override
    public List<DocumentLocation> findExistingDocumentWithFile(CoreSession documentManager, String path, String digest, NuxeoPrincipal principal) {
        String nxql = String.format(QUERY, digest);
        DocumentModelList documentModelList = documentManager.query(nxql, 15);
        ArrayList<DocumentLocation> docLocationList = new ArrayList<DocumentLocation>(documentModelList.size());
        for (DocumentModel documentModel : documentModelList) {
            docLocationList.add((DocumentLocation)new DocumentLocationImpl(documentModel));
        }
        return docLocationList;
    }

    @Override
    public boolean isUnicityEnabled() {
        return this.unicityEnabled;
    }

    @Override
    public boolean isDigestComputingEnabled() {
        return this.computeDigest;
    }

    @Override
    public List<String> getFields() {
        return this.fieldsXPath;
    }

    @Override
    public DocumentModelList getCreationContainers(NuxeoPrincipal principal, String docType) {
        DocumentModelListImpl containers = new DocumentModelListImpl();
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreSession session = CoreInstance.getCoreSession((String)repositoryName, (NuxeoPrincipal)principal);
            DocumentModelList docs = this.getCreationContainers(session, docType);
            docs.forEach(doc -> doc.detach(true));
            containers.addAll((Collection)docs);
        }
        return containers;
    }

    @Override
    public DocumentModelList getCreationContainers(CoreSession documentManager, String docType) {
        for (CreationContainerListProvider provider : this.creationContainerListProviders) {
            if (!provider.accept(docType)) continue;
            return provider.getCreationContainerList(documentManager, docType);
        }
        return new DocumentModelListImpl();
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    @Deprecated(since="9.1")
    public VersioningOption getVersioningOption() {
        return this.defaultVersioningOption;
    }

    @Override
    @Deprecated(since="9.1")
    public boolean doVersioningAfterAdd() {
        return this.versioningAfterAdd;
    }
}

