/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PooledDataSourceRegistry {
    protected final Map<String, DataSource> dataSources = new ConcurrentHashMap<String, DataSource>();
    protected final Map<String, DataSource> dataSourcesNoSharing = new ConcurrentHashMap<String, DataSource>();

    public <T> T getDataSource(String name, Class<T> type, boolean noSharing) {
        Map<String, DataSource> map = noSharing ? this.dataSourcesNoSharing : this.dataSources;
        return type.cast(map.get(name));
    }

    public void registerPooledDataSource(String name, Map<String, String> properties) {
        this.dataSources.computeIfAbsent(name, k -> this.createPooledDataSource(properties, false));
        this.dataSourcesNoSharing.computeIfAbsent(name, k -> this.createPooledDataSource(properties, true));
    }

    public BasicManagedDataSource createPooledDataSource(Map<String, String> properties, boolean noSharing) {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        TransactionManager transactionManager;
        properties.computeIfAbsent("minTotal", k -> (String)properties.get("minPoolSize"));
        properties.computeIfAbsent("maxTotal", k -> (String)properties.get("maxPoolSize"));
        properties.computeIfAbsent("maxWaitMillis", k -> (String)properties.get("blockingTimeoutMillis"));
        properties.computeIfAbsent("username", k -> StringUtils.defaultString((String)((String)properties.get("user")), (String)((String)properties.get("User"))));
        properties.computeIfAbsent("XADataSource", k -> (String)properties.get("xaDataSource"));
        properties.computeIfAbsent("URL", k -> (String)properties.get("url"));
        ConfigurableManagedDataSource ds = new ConfigurableManagedDataSource(properties);
        ds.setMaxWaitMillis(1000L);
        ds.setAccessToUnderlyingConnectionAllowed(true);
        try {
            BeanUtils.populate((Object)((Object)ds), properties);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        properties.forEach((arg_0, arg_1) -> ((BasicManagedDataSource)ds).addConnectionProperty(arg_0, arg_1));
        if (noSharing) {
            transactionManager = new TransactionManagerWithoutTransaction();
            transactionSynchronizationRegistry = null;
        } else {
            try {
                transactionManager = TransactionHelper.lookupTransactionManager();
                transactionSynchronizationRegistry = TransactionHelper.lookupSynchronizationRegistry();
            }
            catch (NamingException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        ds.setTransactionManager(transactionManager);
        ds.setTransactionSynchronizationRegistry(transactionSynchronizationRegistry);
        return ds;
    }

    protected void unregisterPooledDataSource(String name) {
        this.dataSources.remove(name);
        this.dataSourcesNoSharing.remove(name);
    }

    public void createAlias(String name, DataSource ds) {
        for (Map.Entry<String, DataSource> es : this.dataSources.entrySet()) {
            if (es.getValue() != ds) continue;
            DataSource noSharingDs = this.dataSourcesNoSharing.get(es.getKey());
            if (noSharingDs == null) break;
            this.dataSourcesNoSharing.put(name, noSharingDs);
            break;
        }
        this.dataSources.put(name, ds);
    }

    public void removeAlias(String name) {
        this.unregisterPooledDataSource(name);
    }

    public static class TransactionManagerWithoutTransaction
    implements TransactionManager {
        public Transaction getTransaction() {
            return null;
        }

        public int getStatus() {
            return 6;
        }

        public void setTransactionTimeout(int seconds) {
        }

        public void begin() {
            throw new UnsupportedOperationException();
        }

        public void commit() {
            throw new UnsupportedOperationException();
        }

        public void rollback() {
            throw new UnsupportedOperationException();
        }

        public void resume(Transaction transaction) {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
            throw new UnsupportedOperationException();
        }

        public Transaction suspend() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ConfigurableManagedDataSource
    extends BasicManagedDataSource {
        private static final Logger log = LogManager.getLogger(ConfigurableManagedDataSource.class);
        protected final Map<String, String> properties;

        public ConfigurableManagedDataSource(Map<String, String> properties) {
            this.properties = properties;
        }

        protected ConnectionFactory createConnectionFactory() throws SQLException {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            this.configureXADataSource(this.getXaDataSourceInstance());
            return connectionFactory;
        }

        protected void configureXADataSource(XADataSource xaDataSource) {
            if (xaDataSource != null) {
                try {
                    BeanUtils.populate((Object)xaDataSource, this.properties);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

