/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.RecoverableClientException;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    private static final Log log = LogFactory.getLog(ExceptionHandler.class);

    public Response toResponse(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        int status = 500;
        if (e instanceof WebApplicationException) {
            status = ((WebApplicationException)e).getResponse().getStatus();
            if (status < 400 || status >= 500) {
                log.error((Object)("Status = " + status));
                log.error((Object)e, (Throwable)e);
            }
        } else if (e.getCause() instanceof RecoverableClientException && "QuotaExceededException".equals(e.getCause().getClass().getSimpleName())) {
            status = 507;
            log.debug((Object)e, (Throwable)e);
        } else {
            log.error((Object)e, (Throwable)e);
        }
        return Response.status((int)status).build();
    }
}

