/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Entity
@NamedQueries(value={@NamedQuery(name="UIDSequence.findByKey", query="from UIDSequenceBean seq where seq.key = :key")})
@Table(name="NXP_UIDSEQ")
public class UIDSequenceBean {
    public static final Log log = LogFactory.getLog(UIDSequenceBean.class);
    @Id
    @Column(name="SEQ_ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    protected int id;
    @Column(name="SEQ_KEY", nullable=false, unique=true)
    private String key;
    @Column(name="SEQ_INDEX", nullable=false)
    private int index;

    public UIDSequenceBean() {
    }

    public UIDSequenceBean(String key) {
        this.key = key;
        this.index = 0;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getIndex() {
        return this.index;
    }

    public static String stringify(UIDSequenceBean bean) {
        return "UIDSeq(" + bean.key + "," + bean.index + ")";
    }

    public String toString() {
        return UIDSequenceBean.stringify(this);
    }

    public int nextIndex() {
        ++this.index;
        log.debug((Object)("updated to " + this));
        return this.index;
    }
}

