/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.dropwizard5;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class DropWizardUtils {
    private static final String SOURCE = "dropwizard5";
    private static final char DELIMITER = '_';

    static String generateFullMetricName(String name, String type) {
        return "dropwizard5_" + name + '_' + type;
    }

    static String generateFullMetricDescription(String metricName, Metric metric) {
        return "Collected from dropwizard5 (metric=" + metricName + ", type=" + metric.getClass().getName() + ")";
    }

    static AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> generateLabels(MetricName dropwizardMetric) {
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>();
        ArrayList<LabelValue> labelValues = new ArrayList<LabelValue>();
        for (Map.Entry tag : dropwizardMetric.getTags().entrySet()) {
            labelKeys.add(LabelKey.create((String)((String)tag.getKey()), (String)((String)tag.getKey())));
            labelValues.add(LabelValue.create((String)((String)tag.getValue())));
        }
        return new AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>>(labelKeys, labelValues);
    }

    private DropWizardUtils() {
    }
}

