/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.model.impl.PropertyFactory;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonReader;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentPropertiesJsonReader
extends AbstractJsonReader<List<Property>> {
    private static final Logger log = LogManager.getLogger(DocumentPropertiesJsonReader.class);
    public static final String DEFAULT_SCHEMA_NAME = "DEFAULT_SCHEMA_NAME";
    public static final String FALLBACK_RESOLVER = "resolver.";
    @Inject
    private SchemaManager schemaManager;

    @Override
    public List<Property> read(JsonNode jn) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        Iterator propertyNodes = jn.fields();
        while (propertyNodes.hasNext()) {
            Property property;
            DocumentPartImpl parent;
            Field field;
            Map.Entry propertyNode = (Map.Entry)propertyNodes.next();
            String propertyName = (String)propertyNode.getKey();
            if (propertyName.contains(":")) {
                field = this.schemaManager.getField(propertyName);
                if (field == null) continue;
                parent = new DocumentPartImpl(field.getDeclaringType().getSchema());
            } else {
                String shemaName = (String)this.ctx.getParameter(DEFAULT_SCHEMA_NAME);
                Schema schema = this.schemaManager.getSchema(shemaName);
                if (schema == null) continue;
                field = schema.getField(propertyName);
                parent = new DocumentPartImpl(schema);
            }
            if (field == null || (property = this.readProperty((Property)parent, field, (JsonNode)propertyNode.getValue())) == null) continue;
            properties.add(property);
        }
        return properties;
    }

    protected Property readProperty(Property parent, Field field, JsonNode jn) throws IOException {
        Property property = PropertyFactory.createProperty((Property)parent, (Field)field, (int)0);
        property.setForceDirty(true);
        if (jn.isNull()) {
            property.setValue(null);
        } else if (property.isScalar()) {
            this.fillScalarProperty(property, jn);
        } else if (property.isList()) {
            this.fillListProperty(property, jn);
        } else if (!(property instanceof BlobProperty)) {
            this.fillComplexProperty(property, jn);
        } else {
            Blob blob = (Blob)this.readEntity(Blob.class, (Type)((Object)Blob.class), jn);
            property.setValue((Object)blob);
        }
        property.setForceDirty(false);
        return property;
    }

    private void fillScalarProperty(Property property, JsonNode jn) throws IOException {
        if (property instanceof ArrayProperty && jn.isArray()) {
            ArrayList<Object> values = new ArrayList<Object>();
            Iterator it = jn.elements();
            org.nuxeo.ecm.core.schema.types.Type fieldType = ((ListType)property.getType()).getFieldType();
            while (it.hasNext()) {
                JsonNode item = (JsonNode)it.next();
                values.add(this.getScalarPropertyValue(property, item, fieldType));
            }
            property.setValue(this.castArrayPropertyValue((org.nuxeo.ecm.core.schema.types.Type)((SimpleType)fieldType).getPrimitiveType(), values));
        } else {
            property.setValue(this.getScalarPropertyValue(property, jn, property.getType()));
        }
    }

    private <T> T[] castArrayPropertyValue(org.nuxeo.ecm.core.schema.types.Type type, List<Object> values) {
        if (type instanceof StringType) {
            return values.toArray((Object[])Array.newInstance(String.class, values.size()));
        }
        if (type instanceof BooleanType) {
            return values.toArray((Object[])Array.newInstance(Boolean.class, values.size()));
        }
        if (type instanceof LongType) {
            return values.toArray((Object[])Array.newInstance(Long.class, values.size()));
        }
        if (type instanceof DoubleType) {
            return values.toArray((Object[])Array.newInstance(Double.class, values.size()));
        }
        if (type instanceof IntegerType) {
            return values.toArray((Object[])Array.newInstance(Integer.class, values.size()));
        }
        if (type instanceof BinaryType) {
            return values.toArray((Object[])Array.newInstance(Byte.class, values.size()));
        }
        if (type instanceof DateType) {
            return values.toArray((Object[])Array.newInstance(Calendar.class, values.size()));
        }
        throw new MarshallingException("Primitive type not found: " + type.getName());
    }

    private Object getScalarPropertyValue(Property property, JsonNode jn, org.nuxeo.ecm.core.schema.types.Type type) throws IOException {
        Object value;
        if (jn.isObject()) {
            ObjectResolver resolver = type.getObjectResolver();
            if (resolver == null) {
                resolver = (ObjectResolver)this.ctx.getParameter(FALLBACK_RESOLVER + property.getName());
            }
            if (resolver == null) {
                Blob blob;
                if (type.getSuperType() instanceof StringType && (blob = (Blob)this.readEntity(Blob.class, (Type)((Object)Blob.class), jn)) != null) {
                    return blob.getString();
                }
                throw new MarshallingException("Unable to parse the property " + property.getXPath());
            }
            Object object = null;
            for (Class clazz : resolver.getManagedClasses()) {
                try {
                    object = this.readEntity(clazz, clazz, jn);
                    if (object == null) continue;
                    break;
                }
                catch (MarshallingException e) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((MarshallingException)e).getMessage();
                    supplierArray[1] = () -> e;
                    log.info("Unable to read the entity - {}", supplierArray);
                }
            }
            if (object == null) {
                throw new MarshallingException("Unable to parse the property " + property.getXPath());
            }
            value = resolver.getReference(object);
            if (value == null) {
                throw new MarshallingException("Property " + property.getXPath() + " value cannot be resolved by the matching resolver " + resolver.getName());
            }
        } else {
            value = this.getPropertyValue((org.nuxeo.ecm.core.schema.types.Type)((SimpleType)type).getPrimitiveType(), jn);
        }
        return value;
    }

    private Object getPropertyValue(org.nuxeo.ecm.core.schema.types.Type type, JsonNode jn) throws IOException {
        Object value = jn.isNull() ? null : (type instanceof BooleanType ? Boolean.valueOf(jn.asBoolean()) : (type instanceof LongType ? Long.valueOf(jn.asLong()) : (type instanceof DoubleType ? Double.valueOf(jn.asDouble()) : (type instanceof IntegerType ? Integer.valueOf(jn.asInt()) : (type instanceof BinaryType ? (Object)jn.binaryValue() : type.decode(jn.asText()))))));
        return value;
    }

    private void fillListProperty(Property property, JsonNode jn) throws IOException {
        ListType listType = (ListType)property.getType();
        if (property instanceof ArrayProperty) {
            this.fillScalarProperty(property, jn);
        } else if (jn.isEmpty()) {
            property.setValue(null);
        } else {
            Iterator it = jn.elements();
            while (it.hasNext()) {
                JsonNode elNode = (JsonNode)it.next();
                Property child = this.readProperty(property, listType.getField(), elNode);
                property.addValue((Object)child.getValue());
            }
        }
    }

    private void fillComplexProperty(Property property, JsonNode jn) throws IOException {
        Iterator it = jn.fields();
        ComplexProperty complexProperty = (ComplexProperty)property;
        ComplexType type = complexProperty.getType();
        while (it.hasNext()) {
            Map.Entry elNode = (Map.Entry)it.next();
            String elName = (String)elNode.getKey();
            Field field = type.getField(elName);
            if (field == null) continue;
            Property child = this.readProperty(property, field, (JsonNode)elNode.getValue());
            property.set(elName, child);
        }
    }
}

