/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.http.ProxyHelper;

public class HttpClientBuilderHelper {
    protected static int connectHttpTimeout = Integer.parseInt(NuxeoConnectClient.getProperty("org.nuxeo.connect.http.timeout", "10000"));

    public static HttpClientBuilder getHttpClientBuilder(Integer socketTimeout, Integer connectTimeout, String url) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("standard");
        if (socketTimeout != null) {
            requestConfigBuilder.setSocketTimeout(socketTimeout);
        }
        if (connectTimeout != null) {
            requestConfigBuilder.setConnectTimeout(connectTimeout);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        ProxyHelper.configureProxyIfNeeded(requestConfigBuilder, credentialsProvider, url);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClientBuilder.setConnectionTimeToLive(connectHttpTimeout, TimeUnit.MILLISECONDS);
        return httpClientBuilder;
    }
}

