/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.connect.update.task.update.Version;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RegistrySerializer
extends XmlWriter {
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public RegistrySerializer() {
        super("  ");
    }

    public static void store(Map<String, Entry> registry, File file) throws IOException {
        RegistrySerializer serializer = new RegistrySerializer();
        serializer.write(registry);
        serializer.write(file);
    }

    public static Map<String, Entry> load(File file) throws PackageException, IOException {
        RegistrySerializer serializer = new RegistrySerializer();
        return serializer.read(file);
    }

    protected Map<String, Entry> read(File file) throws PackageException, IOException {
        HashMap<String, Entry> hashMap;
        FileInputStream in = new FileInputStream(file);
        try {
            HashMap<String, Entry> registry = new HashMap<String, Entry>();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            this.read(document.getDocumentElement(), registry);
            hashMap = registry;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return hashMap;
    }

    protected void read(Element element, Map<String, Entry> registry) throws PackageException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"entry".equals(node.getNodeName())) continue;
            Entry entry = this.readEntryElement((Element)node);
            registry.put(entry.getKey(), entry);
        }
    }

    protected Entry readEntryElement(Element element) throws PackageException {
        Entry entry = new Entry(this.readKeyAttr(element));
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Version v;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("version".equals(name)) {
                v = this.readVersionElement((Element)node);
                entry.addVersion(v);
                continue;
            }
            if (!"base-version".equals(name)) continue;
            v = this.readVersionElement((Element)node);
            entry.setBaseVersion(v);
        }
        return entry;
    }

    protected String readKeyAttr(Element element) throws PackageException {
        String key = element.getAttribute("key");
        if (key.length() == 0) {
            throw new PackageException("Invalid entry. No 'key' attribute found!");
        }
        return key;
    }

    protected String readNameAttr(Element element) throws PackageException {
        String version = element.getAttribute("name");
        if (version.length() == 0) {
            throw new PackageException("Invalid version entry. No 'name' attribute found!");
        }
        return version;
    }

    protected String readPathAttr(Element element) throws PackageException {
        String path = element.getAttribute("path");
        if (path.length() == 0) {
            throw new PackageException("Invalid version entry. No 'path' attribute found!");
        }
        return path;
    }

    protected Version readVersionElement(Element element) throws PackageException {
        Version v = new Version(this.readNameAttr(element));
        v.setPath(this.readPathAttr(element));
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"package".equals(node.getNodeName())) continue;
            UpdateOptions opt = new UpdateOptions();
            opt.pkgId = node.getTextContent().trim();
            opt.upgradeOnly = Boolean.parseBoolean(((Element)node).getAttribute("upgradeOnly"));
            v.addPackage(opt);
        }
        return v;
    }

    protected void write(Map<String, Entry> registry) {
        this.writeXmlDecl();
        this.start("registry");
        this.startContent();
        for (Entry entry : registry.values()) {
            this.writeEntry(entry);
        }
        this.end("registry");
    }

    protected void writeEntry(Entry entry) {
        this.start("entry");
        this.attr("key", entry.getKey());
        this.startContent();
        if (entry.hasBaseVersion()) {
            this.writeBaseVersion(entry.getBaseVersion());
        }
        for (Version v : entry) {
            this.writeVersion(v);
        }
        this.end("entry");
    }

    protected void writeBaseVersion(Version version) {
        this.start("base-version");
        this.attr("name", version.getVersion());
        this.attr("path", version.getPath());
        this.end();
    }

    protected void writeVersion(Version version) {
        this.start("version");
        this.attr("name", version.getVersion());
        this.attr("path", version.getPath());
        this.startContent();
        Map<String, UpdateOptions> packages = version.getPackages();
        for (UpdateOptions opt : packages.values()) {
            this.start("package");
            if (opt.upgradeOnly) {
                this.attr("upgradeOnly", "true");
            }
            this.text(">" + opt.pkgId + "</package>\n");
        }
        this.end("version");
    }

    protected void write(File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));){
            writer.write(this.sb.toString());
        }
    }
}

