/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;

@XObject(value="userManager")
public class UserManagerDescriptor {
    @XNode(value="@class")
    public Class<?> userManagerClass;
    @XNode(value="defaultGroup")
    public String defaultGroup;
    @XNodeList(value="defaultAdministratorId", type=ArrayList.class, componentType=String.class)
    public List<String> defaultAdministratorIds;
    @XNodeList(value="administratorsGroup", type=ArrayList.class, componentType=String.class)
    public List<String> administratorsGroups;
    @XNode(value="disableDefaultAdministratorsGroup")
    public Boolean disableDefaultAdministratorsGroup;
    @XNode(value="userSortField")
    public String userSortField;
    @XNode(value="groupSortField")
    public String groupSortField;
    @XNode(value="users/directory")
    public String userDirectoryName;
    @XNode(value="users/emailField")
    public String userEmailField;
    @XNode(value="users/listingMode")
    public String userListingMode;
    public boolean userSearchFieldsPresent = false;
    @XNode(value="users/searchFields@append")
    public boolean userSearchFieldsAppend;
    public Map<String, UserManager.MatchType> userSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
    public Pattern userPasswordPattern;
    @XNode(value="users/anonymousUser")
    public VirtualUserDescriptor anonymousUser;
    @XNodeMap(value="users/virtualUser", key="@id", type=HashMap.class, componentType=VirtualUserDescriptor.class)
    public Map<String, VirtualUserDescriptor> virtualUsers;
    @XNode(value="groups/directory")
    public String groupDirectoryName;
    @XNode(value="groups/groupLabelField")
    public String groupLabelField;
    @XNode(value="groups/membersField")
    public String groupMembersField;
    @XNode(value="groups/subGroupsField")
    public String groupSubGroupsField;
    @XNode(value="groups/parentGroupsField")
    public String groupParentGroupsField;
    @XNode(value="groups/listingMode")
    public String groupListingMode;
    public boolean groupSearchFieldsPresent = false;
    @XNode(value="groups/searchFields@append")
    public boolean groupSearchFieldsAppend;
    public Map<String, UserManager.MatchType> groupSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
    @XNode(value="digestAuthDirectory")
    public String digestAuthDirectory;
    @XNode(value="digestAuthRealm")
    public String digestAuthRealm;
    @XNode(value="userCacheName")
    public String userCacheName;

    @XNode(value="userListingMode")
    public void setUserListingMode(String userListingMode) {
        this.userListingMode = userListingMode;
    }

    @XNode(value="users/searchFields")
    public void setUserSearchFieldsPresent(String text) {
        this.userSearchFieldsPresent = true;
    }

    @XNodeList(value="users/searchFields/exactMatchSearchField", componentType=String.class, type=String[].class)
    public void setExactMatchUserSearchFields(String[] fields) {
        for (String field : fields) {
            this.userSearchFields.put(field, UserManager.MatchType.EXACT);
        }
    }

    @XNodeList(value="users/searchFields/substringMatchSearchField", componentType=String.class, type=String[].class)
    public void setSubstringMatchUserSearchFields(String[] fields) {
        for (String field : fields) {
            this.userSearchFields.put(field, UserManager.MatchType.SUBSTRING);
        }
    }

    @XNode(value="userPasswordPattern")
    public void setUserPasswordPattern(String pattern) {
        this.userPasswordPattern = Pattern.compile(pattern);
    }

    @XNode(value="groups/searchFields")
    public void setGroupSearchFieldsPresent(String text) {
        this.groupSearchFieldsPresent = true;
    }

    @XNodeList(value="groups/searchFields/exactMatchSearchField", componentType=String.class, type=String[].class)
    public void setExactMatchGroupSearchFields(String[] fields) {
        for (String field : fields) {
            this.groupSearchFields.put(field, UserManager.MatchType.EXACT);
        }
    }

    @XNodeList(value="groups/searchFields/substringMatchSearchField", componentType=String.class, type=String[].class)
    public void setSubstringMatchGroupSearchFields(String[] fields) {
        for (String field : fields) {
            this.groupSearchFields.put(field, UserManager.MatchType.SUBSTRING);
        }
    }

    public void merge(UserManagerDescriptor other) {
        if (other.userManagerClass != null) {
            this.userManagerClass = other.userManagerClass;
        }
        if (other.userCacheName != null) {
            this.userCacheName = other.userCacheName;
        }
        if (other.userListingMode != null) {
            this.userListingMode = other.userListingMode;
        }
        if (other.groupListingMode != null) {
            this.groupListingMode = other.groupListingMode;
        }
        if (other.defaultGroup != null) {
            this.defaultGroup = other.defaultGroup;
        }
        if (other.defaultAdministratorIds != null) {
            if (this.defaultAdministratorIds == null) {
                this.defaultAdministratorIds = new ArrayList<String>();
            }
            this.defaultAdministratorIds.addAll(other.defaultAdministratorIds);
        }
        if (other.administratorsGroups != null) {
            if (this.administratorsGroups == null) {
                this.administratorsGroups = new ArrayList<String>();
            }
            this.administratorsGroups.addAll(other.administratorsGroups);
        }
        if (other.disableDefaultAdministratorsGroup != null) {
            this.disableDefaultAdministratorsGroup = other.disableDefaultAdministratorsGroup;
        }
        if (other.userSearchFieldsPresent) {
            if (other.userSearchFieldsAppend) {
                this.userSearchFields.putAll(other.userSearchFields);
            } else {
                this.userSearchFields = other.userSearchFields;
            }
        }
        if (other.userSortField != null) {
            this.userSortField = other.userSortField;
        }
        if (other.groupSortField != null) {
            this.groupSortField = other.groupSortField;
        }
        if (other.userDirectoryName != null) {
            this.userDirectoryName = other.userDirectoryName;
        }
        if (other.userEmailField != null) {
            this.userEmailField = other.userEmailField;
        }
        if (other.userSearchFieldsPresent) {
            if (other.userSearchFieldsAppend) {
                this.userSearchFields.putAll(other.userSearchFields);
            } else {
                this.userSearchFields = other.userSearchFields;
            }
        }
        if (other.userPasswordPattern != null) {
            this.userPasswordPattern = other.userPasswordPattern;
        }
        if (other.groupDirectoryName != null) {
            this.groupDirectoryName = other.groupDirectoryName;
        }
        if (other.groupLabelField != null) {
            this.groupLabelField = other.groupLabelField;
        }
        if (other.groupMembersField != null) {
            this.groupMembersField = other.groupMembersField;
        }
        if (other.groupSubGroupsField != null) {
            this.groupSubGroupsField = other.groupSubGroupsField;
        }
        if (other.groupParentGroupsField != null) {
            this.groupParentGroupsField = other.groupParentGroupsField;
        }
        if (other.groupSearchFieldsPresent) {
            if (other.groupSearchFieldsAppend) {
                this.groupSearchFields.putAll(other.groupSearchFields);
            } else {
                this.groupSearchFields = other.groupSearchFields;
            }
        }
        if (other.anonymousUser != null) {
            this.anonymousUser = other.anonymousUser.remove ? null : other.anonymousUser;
        }
        if (other.virtualUsers != null) {
            if (this.virtualUsers == null) {
                this.virtualUsers = other.virtualUsers;
            } else {
                for (VirtualUserDescriptor otherVirtualUser : other.virtualUsers.values()) {
                    if (this.virtualUsers.containsKey(otherVirtualUser.id) && otherVirtualUser.remove) {
                        this.virtualUsers.remove(otherVirtualUser.id);
                        continue;
                    }
                    this.virtualUsers.put(otherVirtualUser.id, otherVirtualUser);
                }
            }
        }
        if (other.digestAuthDirectory != null) {
            this.digestAuthDirectory = other.digestAuthDirectory;
        }
        if (other.digestAuthRealm != null) {
            this.digestAuthRealm = other.digestAuthRealm;
        }
    }
}

