/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BlobPreviewJsonEnricher
extends AbstractJsonEnricher<BlobProperty> {
    public static final String NAME = "preview";

    public BlobPreviewJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, BlobProperty blobProperty) throws IOException {
        Blob blob = (Blob)blobProperty.getValue();
        if (!(blob instanceof ManagedBlob)) {
            return;
        }
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        URI uri = blobManager.getURI(blob, BlobManager.UsageHint.EMBED, null);
        if (uri != null) {
            jg.writeStringField(NAME, uri.toASCIIString());
        }
    }
}

