/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;

@XObject(value="loginProvider")
public class LoginProviderLink {
    protected static final Log log = LogFactory.getLog(LoginProviderLink.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="label")
    protected String label;
    @XNode(value="@remove")
    protected boolean remove = false;
    protected String iconPath;
    protected String link;
    @XNode(value="@class")
    protected Class<LoginProviderLinkComputer> urlComputerClass;
    protected LoginProviderLinkComputer urlComputer;
    @XNode(value="description")
    protected String description;

    public LoginProviderLink() {
    }

    public LoginProviderLink(String name, String iconPath, String link, String label, String description, LoginProviderLinkComputer urlComputer) {
        this.name = name;
        this.iconPath = iconPath;
        this.link = link;
        this.label = label;
        this.description = description;
        this.urlComputer = urlComputer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LoginProviderLink && this.name != null) {
            return this.name.equals(((LoginProviderLink)obj).getName());
        }
        return super.equals(obj);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    @XNode(value="iconPath")
    public void setIconPath(String iconPath) {
        this.iconPath = Framework.expandVars((String)iconPath);
    }

    public String getLink(HttpServletRequest req, String requestedUrl) {
        if (this.urlComputerClass != null && this.urlComputer == null) {
            try {
                this.urlComputer = this.urlComputerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to instantiate LoginProviderLinkComputer", (Throwable)e);
            }
        }
        if (this.urlComputer != null) {
            return this.urlComputer.computeUrl(req, requestedUrl);
        }
        return this.link;
    }

    @XNode(value="link")
    public void setLink(String link) {
        this.link = Framework.expandVars((String)link);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public String getLink() {
        return this.link;
    }

    public void merge(LoginProviderLink newLink) {
        if (newLink.link != null) {
            this.link = newLink.link;
        }
        if (newLink.description != null) {
            this.description = newLink.description;
        }
        if (newLink.iconPath != null) {
            this.iconPath = newLink.iconPath;
        }
    }

    protected LoginProviderLink clone() {
        LoginProviderLink clone = new LoginProviderLink();
        clone.description = this.description;
        clone.iconPath = this.iconPath;
        clone.label = this.label;
        clone.link = this.link;
        clone.name = this.name;
        clone.remove = this.remove;
        clone.urlComputerClass = this.urlComputerClass;
        return clone;
    }
}

