/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="openUrl")
public class OpenUrlDescriptor {
    @XNode(value="@name")
    protected String name;
    protected String grantPattern;
    protected Pattern compiledGrantPattern;
    @XNode(value="denyPattern")
    protected String denyPattern;
    protected Pattern compiledDenyPattern;
    @XNode(value="method")
    protected String method;

    public String getName() {
        return this.name;
    }

    @XNode(value="grantPattern")
    public void setGrantPattern(String grantPattern) {
        this.grantPattern = Framework.expandVars((String)grantPattern);
    }

    public String getGrantPattern() {
        return this.grantPattern;
    }

    public Pattern getCompiledGrantPattern() {
        if (this.compiledGrantPattern == null && this.grantPattern != null && this.grantPattern.length() > 0) {
            this.compiledGrantPattern = Pattern.compile(this.grantPattern);
        }
        return this.compiledGrantPattern;
    }

    public Pattern getCompiledDenyPattern() {
        if (this.compiledDenyPattern == null && this.denyPattern != null && this.denyPattern.length() > 0) {
            this.compiledDenyPattern = Pattern.compile(this.denyPattern);
        }
        return this.compiledDenyPattern;
    }

    public String getDenyPattern() {
        return this.denyPattern;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean allowByPassAuth(HttpServletRequest httpRequest) {
        Matcher grantMatcher;
        Matcher denyMatcher;
        String uri = httpRequest.getRequestURI();
        String requestMethod = httpRequest.getMethod();
        if (this.method != null && !requestMethod.equals(this.method)) {
            return false;
        }
        Pattern deny = this.getCompiledDenyPattern();
        if (deny != null && (denyMatcher = deny.matcher(uri)).matches()) {
            return false;
        }
        Pattern grant = this.getCompiledGrantPattern();
        return grant != null && (grantMatcher = grant.matcher(uri)).matches();
    }
}

