/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore.api;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreProvider;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="store")
public class TransientStoreConfig
implements Descriptor {
    public static final int DEFAULT_TARGET_MAX_SIZE_MB = -1;
    public static final int DEFAULT_ABSOLUTE_MAX_SIZE_MB = -1;
    public static final int DEFAULT_FIRST_LEVEL_TTL = 120;
    public static final int DEFAULT_SECOND_LEVEL_TTL = 10;
    @XNode(value="@name")
    public String name;
    @XNode(value="@path")
    protected String path;
    @XNode(value="targetMaxSizeMB")
    protected Integer targetMaxSizeMB;
    @XNode(value="absoluteMaxSizeMB")
    protected Integer absoluteMaxSizeMB;
    @XNode(value="firstLevelTTL")
    protected Integer firstLevelTTL;
    @XNode(value="secondLevelTTL")
    protected Integer secondLevelTTL;
    @XNode(value="@class")
    public Class<? extends TransientStoreProvider> implClass;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class, nullByDefault=true)
    protected Map<String, String> properties = new HashMap<String, String>();

    public TransientStoreConfig() {
    }

    public TransientStoreConfig(String name) {
        this.name = name;
    }

    public TransientStoreConfig(TransientStoreConfig other) {
        this.name = other.name;
        this.path = other.path;
        this.targetMaxSizeMB = other.targetMaxSizeMB;
        this.absoluteMaxSizeMB = other.absoluteMaxSizeMB;
        this.firstLevelTTL = other.firstLevelTTL;
        this.secondLevelTTL = other.secondLevelTTL;
        this.implClass = other.implClass;
        this.properties.putAll(other.properties);
    }

    public TransientStoreConfig merge(Descriptor o) {
        TransientStoreConfig other = (TransientStoreConfig)o;
        TransientStoreConfig merged = new TransientStoreConfig();
        merged.name = other.name;
        merged.path = TransientStoreConfig.defaultValue(other.path, this.path);
        merged.targetMaxSizeMB = TransientStoreConfig.defaultValue(other.targetMaxSizeMB, this.targetMaxSizeMB);
        merged.absoluteMaxSizeMB = TransientStoreConfig.defaultValue(other.absoluteMaxSizeMB, this.absoluteMaxSizeMB);
        merged.firstLevelTTL = TransientStoreConfig.defaultValue(other.firstLevelTTL, this.firstLevelTTL);
        merged.secondLevelTTL = TransientStoreConfig.defaultValue(other.secondLevelTTL, this.secondLevelTTL);
        merged.implClass = TransientStoreConfig.defaultValue(other.implClass, this.implClass);
        merged.properties.putAll(this.properties);
        merged.properties.putAll(other.properties);
        return merged;
    }

    protected static <T> T defaultValue(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getTargetMaxSizeMB() {
        return this.targetMaxSizeMB == null ? -1 : this.targetMaxSizeMB;
    }

    @Deprecated
    public void setTargetMaxSizeMB(int targetMaxSizeMB) {
        this.targetMaxSizeMB = targetMaxSizeMB;
    }

    public int getAbsoluteMaxSizeMB() {
        return this.absoluteMaxSizeMB == null ? -1 : this.absoluteMaxSizeMB;
    }

    @Deprecated
    public void setAbsoluteMaxSizeMB(int absoluteMaxSizeMB) {
        this.absoluteMaxSizeMB = absoluteMaxSizeMB;
    }

    public int getFirstLevelTTL() {
        return this.firstLevelTTL == null ? 120 : this.firstLevelTTL;
    }

    @Deprecated
    public void setFirstLevelTTL(int firstLevelTTL) {
        this.firstLevelTTL = firstLevelTTL;
    }

    public int getSecondLevelTTL() {
        return this.secondLevelTTL == null ? 10 : this.secondLevelTTL;
    }

    @Deprecated
    public void setSecondLevelTTL(int secondLevelTTL) {
        this.secondLevelTTL = secondLevelTTL;
    }

    public String getDataDir() {
        return this.path;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Class<? extends TransientStoreProvider> getKlass() {
        return this.implClass;
    }
}

