/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Selection;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidations;
import org.nuxeo.runtime.metrics.MetricsService;

public class SelectionContext {
    private final SelectionType selType;
    private final Serializable criterion;
    private final RowMapper mapper;
    private final PersistenceContext context;
    private final Map<Serializable, Selection> softMap;
    public final Map<Serializable, Selection> hardMap;
    private final Set<Serializable> modifiedInTransaction;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter modifiedInTransactionCount;
    protected final Counter cacheHitCount;
    protected final Timer cacheGetTimer;

    public SelectionContext(SelectionType selType, Serializable criterion, RowMapper mapper, PersistenceContext context) {
        this.selType = selType;
        this.criterion = criterion;
        this.mapper = mapper;
        this.context = context;
        this.softMap = new ReferenceMap(0, 1);
        this.hardMap = new HashMap<Serializable, Selection>();
        this.modifiedInTransaction = new HashSet<Serializable>();
        this.modifiedInTransactionCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "selections", "modified"}).tagged(new String[]{"repository", context.session.repository.getName()}));
        this.cacheHitCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "selections", "hit"}).tagged(new String[]{"repository", context.session.repository.getName()}));
        this.cacheGetTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "selections", "timer"}).tagged(new String[]{"repository", context.session.repository.getName()}));
    }

    public int clearCaches() {
        int n = this.softMap.size();
        this.softMap.clear();
        this.modifiedInTransactionCount.dec((long)this.modifiedInTransaction.size());
        this.modifiedInTransaction.clear();
        return n;
    }

    public int getSize() {
        return this.softMap == null ? 0 : this.softMap.size();
    }

    private Selection getSelection(Serializable selId) {
        Selection selection = this.getSelectionOrNull(selId);
        if (selection != null) {
            return selection;
        }
        return new Selection(selId, this.selType.tableName, false, this.selType.filterKey, this.context, this.softMap, this.hardMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Selection getSelectionOrNull(Serializable selId) {
        Timer.Context timerContext = this.cacheGetTimer.time();
        try {
            Selection selection = this.softMap.get(selId);
            if (selection != null) {
                this.cacheHitCount.inc();
                Selection selection2 = selection;
                return selection2;
            }
            selection = this.hardMap.get(selId);
            if (selection != null) {
                this.cacheHitCount.inc();
                Selection selection3 = selection;
                return selection3;
            }
        }
        finally {
            timerContext.stop();
        }
        return null;
    }

    public boolean applicable(SimpleFragment fragment) {
        Serializable crit;
        if (!fragment.row.tableName.equals(this.selType.tableName)) {
            return false;
        }
        return this.selType.criterionKey == null || this.criterion.equals(crit = fragment.get(this.selType.criterionKey));
    }

    public void recordCreated(SimpleFragment fragment) {
        Serializable id = fragment.getId();
        Serializable selId = fragment.get(this.selType.selKey);
        if (selId != null) {
            this.getSelection(selId).addCreated(id);
            this.modifiedInTransaction.add(selId);
            this.modifiedInTransactionCount.inc();
        }
    }

    public void newSelection(Serializable selId) {
        new Selection(selId, this.selType.tableName, true, this.selType.filterKey, this.context, this.softMap, this.hardMap);
    }

    public void recordExisting(SimpleFragment fragment, boolean invalidate) {
        Serializable selId = fragment.get(this.selType.selKey);
        if (selId != null) {
            this.getSelection(selId).addExisting(fragment.getId());
            if (invalidate) {
                this.modifiedInTransaction.add(selId);
                this.modifiedInTransactionCount.inc();
            }
        }
    }

    public void recordRemoved(SimpleFragment fragment) {
        this.recordRemoved(fragment.getId(), fragment.get(this.selType.selKey));
    }

    public void recordRemoved(Serializable id, Serializable selId) {
        if (selId != null) {
            this.getSelection(selId).remove(id);
            this.modifiedInTransaction.add(selId);
            this.modifiedInTransactionCount.inc();
        }
    }

    public void recordRemovedSelection(Serializable selId) {
        this.softMap.remove(selId);
        this.hardMap.remove(selId);
        this.modifiedInTransaction.add(selId);
        this.modifiedInTransactionCount.inc();
    }

    public SimpleFragment getSelectionFragment(Serializable selId, String filter) {
        SimpleFragment fragment = this.getSelection(selId).getFragmentByValue((Serializable)((Object)filter));
        if (fragment == SimpleFragment.UNKNOWN) {
            List<Row> rows = this.mapper.readSelectionRows(this.selType, selId, (Serializable)((Object)filter), this.criterion, true);
            Row row = rows.isEmpty() ? null : rows.get(0);
            fragment = (SimpleFragment)this.context.getFragmentFromFetchedRow(row, false);
        }
        return fragment;
    }

    public List<SimpleFragment> getSelectionFragments(Serializable selId, String filter) {
        Selection selection = this.getSelection(selId);
        List<SimpleFragment> fragments = selection.getFragmentsByValue((Serializable)((Object)filter));
        if (fragments == null) {
            List<Row> rows = this.mapper.readSelectionRows(this.selType, selId, null, this.criterion, false);
            List<Fragment> frags = this.context.getFragmentsFromFetchedRows(rows, false);
            fragments = new ArrayList<SimpleFragment>(frags.size());
            ArrayList<Serializable> ids = new ArrayList<Serializable>(frags.size());
            for (Fragment fragment : frags) {
                fragments.add((SimpleFragment)fragment);
                ids.add(fragment.getId());
            }
            selection.addExistingComplete(ids);
            fragments = selection.getFragmentsByValue((Serializable)((Object)filter));
        }
        return fragments;
    }

    public Set<Serializable> getSelectionIds(List<Serializable> values) {
        return this.mapper.readSelectionsIds(this.selType, values);
    }

    public void postSave() {
        for (Selection selection : this.hardMap.values()) {
            selection.flush();
        }
        this.hardMap.clear();
    }

    public void markInvalidated(Set<RowId> modified) {
        for (RowId rowId : modified) {
            if (!this.selType.invalidationTableName.equals(rowId.tableName)) continue;
            Serializable id = rowId.id;
            Selection selection = this.softMap.get(id);
            if (selection != null) {
                selection.setIncomplete();
            }
            if ((selection = this.hardMap.get(id)) != null) {
                selection.setIncomplete();
            }
            this.modifiedInTransaction.add(id);
            this.modifiedInTransactionCount.inc();
        }
    }

    public void gatherInvalidations(VCSInvalidations invalidations) {
        for (Serializable id : this.modifiedInTransaction) {
            invalidations.addModified(new RowId(this.selType.invalidationTableName, id));
        }
        this.modifiedInTransactionCount.dec((long)this.modifiedInTransaction.size());
        this.modifiedInTransaction.clear();
    }

    public void processReceivedInvalidations(Set<RowId> modified) {
        for (RowId rowId : modified) {
            if (!this.selType.invalidationTableName.equals(rowId.tableName)) continue;
            Serializable id = rowId.id;
            this.softMap.remove(id);
            this.hardMap.remove(id);
        }
    }
}

