/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.IOException;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Operation(id="FileManager.Import", category="Services", label="Create Document from file", description="Create Document(s) from Blob(s) using the FileManagerService. The destination container must be passed in a Context variable named currentDocument.")
public class FileManagerImport {
    public static final String ID = "FileManager.Import";
    protected static final int IMPORT_TX_TIMEOUT_SEC = 86400;
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;
    @Param(name="overwite", required=false)
    @Deprecated(since="11.2")
    protected Boolean overwite = false;
    @Param(name="overwrite", alias={"overwite"}, required=false)
    protected Boolean overwrite = false;
    @Param(name="noMimeTypeCheck", required=false)
    protected Boolean noMimeTypeCheck = false;

    protected DocumentModel getCurrentDocument() throws OperationException {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws OperationException, IOException {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction((int)86400);
        DocumentModel currentDocument = this.getCurrentDocument();
        String path = currentDocument.getPathAsString();
        FileImporterContext fileCreationContext = FileImporterContext.builder((CoreSession)this.session, (Blob)blob, (String)path).overwrite(this.overwrite.booleanValue()).mimeTypeCheck(this.noMimeTypeCheck == false).build();
        DocumentModel doc = this.fileManager.createOrUpdateDocument(fileCreationContext);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws OperationException, IOException {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        return result;
    }
}

