/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.stream;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.stream.DomainEventProducer;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DomainEventProducerListener
implements EventListener,
Synchronization {
    private static final Logger log = LogManager.getLogger(DomainEventProducerListener.class);
    protected static final ThreadLocal<Boolean> isEnlisted = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected static final ThreadLocal<List<DomainEventProducer>> producers = ThreadLocal.withInitial(ArrayList::new);

    @Override
    public void handleEvent(Event event) {
        if (!Boolean.TRUE.equals(isEnlisted.get())) {
            isEnlisted.set(this.registerSynchronization(this));
            log.debug("Enlisted to transaction");
            this.initDomainEventProducers();
        }
        producers.get().forEach(producer -> producer.addEvent(event));
        if (!Boolean.TRUE.equals(isEnlisted.get())) {
            this.afterCompletion(3);
        }
    }

    protected void initDomainEventProducers() {
        producers.set(((EventService)Framework.getService(EventService.class)).createDomainEventProducers());
    }

    protected void cleanDomainEventProducers() {
        producers.remove();
    }

    public void beforeCompletion() {
        log.debug("beforeCompletion");
    }

    public void afterCompletion(int status) {
        try {
            if (3 == status) {
                log.debug("Sending domain events after commit");
                this.produceDomainEvents();
            } else {
                log.info("Skip domain events transaction status is not committed: {}", (Object)status);
            }
        }
        finally {
            isEnlisted.set(false);
            this.cleanDomainEventProducers();
        }
    }

    protected void produceDomainEvents() {
        StreamService streamService = (StreamService)Framework.getService(StreamService.class);
        for (DomainEventProducer producer : producers.get()) {
            List<Record> records = producer.getDomainEvents();
            if (records.isEmpty()) continue;
            log.debug("Writing domain events");
            StreamManager streamManager = streamService.getStreamManager();
            String stream = producer.getStream();
            records.forEach(record -> streamManager.append(stream, record));
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm != null) {
                if (tm.getTransaction() != null) {
                    tm.getTransaction().registerSynchronization(sync);
                    return true;
                }
                return false;
            }
            log.error("Unable to register synchronization: no TransactionManager");
            return false;
        }
        catch (IllegalStateException | NamingException | RollbackException | SystemException e) {
            log.error("Unable to register synchronization", e);
            return false;
        }
    }
}

