/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.pdf.PDFEncryption;

@Operation(id="PDF.EncryptReadOnly", category="Conversion", label="PDF: Encrypt Read Only", description="Encrypts the PDF, returning a copy. User can read, print and copy but cannot modify. originalOwnerPwd is used if the PDF was originally encrypted. If ownerPwd is empty, use originalOwnerPwd to encrypt. If no keyLength is provided, use 128. If the operation is ran on Document(s), xpath lets you specificy where to get the blob from (default: file:content).")
public class PDFEncryptReadOnlyOperation {
    public static final String ID = "PDF.EncryptReadOnly";
    @Param(name="originalOwnerPwd", required=false)
    protected String originalOwnerPwd;
    @Param(name="ownerPwd", required=false)
    protected String ownerPwd;
    @Param(name="userPwd", required=false)
    protected String userPwd;
    @Param(name="keyLength", required=false, widget="Option", values={"40", "128"})
    protected String keyLength = "128";
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";

    @OperationMethod
    public Blob run(Blob inBlob) {
        PDFEncryption pdfe = new PDFEncryption(inBlob);
        pdfe.setKeyLength(Integer.parseInt(this.keyLength));
        pdfe.setOriginalOwnerPwd(this.originalOwnerPwd);
        pdfe.setOwnerPwd(this.ownerPwd);
        pdfe.setUserPwd(this.userPwd);
        Blob result = pdfe.encryptReadOnly();
        return result;
    }

    @OperationMethod
    public BlobList run(BlobList inBlobs) {
        return inBlobs.stream().map(this::run).collect(Collectors.toCollection(BlobList::new));
    }

    @OperationMethod
    public Blob run(DocumentModel inDoc) {
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
        Blob result = null;
        Blob content = (Blob)inDoc.getPropertyValue(this.xpath);
        if (content != null) {
            result = this.run(content);
        }
        return result;
    }

    @OperationMethod
    public BlobList run(DocumentModelList inDocs) {
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
        return inDocs.stream().map(this::run).collect(Collectors.toCollection(BlobList::new));
    }
}

