/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.jvm.JmxAttributeGauge;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.runtime.metrics.MetricsService;

public class ObjectPoolMonitor
implements ConnectionPoolMonitor {
    protected static final MetricRegistry METRICS = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final String name;
    protected final GenericKeyedObjectPool<String, ?> pool;
    protected final String key;
    protected MetricName countGauge;
    protected MetricName idleGauge;
    protected MetricName killedGauge;
    protected DefaultMonitorComponent.ServerInstance self;

    protected ObjectPoolMonitor(String name, GenericKeyedObjectPool<String, ?> pool, String key) {
        this.name = name;
        this.pool = pool;
        this.key = key;
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(this, this.name);
        this.countGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "count"}).tagged(new String[]{"repository", this.name});
        this.idleGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "idle"}).tagged(new String[]{"repository", this.name});
        this.killedGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "killed"}).tagged(new String[]{"repository", this.name});
        METRICS.register(this.countGauge, (Metric)new JmxAttributeGauge(this.self.name, "ConnectionCount"));
        METRICS.register(this.idleGauge, (Metric)new JmxAttributeGauge(this.self.name, "IdleConnectionCount"));
        METRICS.register(this.killedGauge, (Metric)new JmxAttributeGauge(this.self.name, "KilledActiveConnectionCount"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        METRICS.remove(this.countGauge);
        METRICS.remove(this.idleGauge);
        METRICS.remove(this.killedGauge);
        this.self = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getConnectionCount() {
        return this.pool.getNumActive((Object)this.key) + this.pool.getNumIdle((Object)this.key);
    }

    @Override
    public int getIdleConnectionCount() {
        return this.pool.getNumIdle((Object)this.key);
    }

    @Override
    public int getBlockingTimeoutMilliseconds() {
        return (int)this.pool.getMaxWaitMillis();
    }

    @Override
    public int getIdleTimeoutMinutes() {
        return -1;
    }

    @Override
    public int getActiveTimeoutMinutes() {
        return -1;
    }

    @Override
    public void reset() {
        this.pool.clear();
    }

    @Override
    public long getKilledActiveConnectionCount() {
        return 0L;
    }

    @Override
    public int killActiveTimedoutConnections() {
        return 0;
    }
}

