/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoConversionWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoConversionWork.class);
    public static final String CATEGORY_VIDEO_CONVERSION = "videoConversion";
    public static final String VIDEO_CONVERSIONS_DONE_EVENT = "videoConversionsDone";
    protected final String conversionName;

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":videoconv:";
    }

    public VideoConversionWork(String repositoryName, String docId, String conversionName) {
        super(VideoConversionWork.computeIdPrefix(repositoryName, docId) + conversionName);
        this.setDocument(repositoryName, docId);
        this.conversionName = conversionName;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_CONVERSION;
    }

    public String getTitle() {
        return "Video Conversion: " + this.conversionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        Video originalVideo;
        DocumentModel doc;
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        try {
            Blob originalBlob;
            this.openSystemSession();
            doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            originalVideo = this.getVideoToConvert(doc);
            if (originalVideo == null || (originalBlob = originalVideo.getBlob()) == null || originalBlob.getLength() == 0L) {
                this.resetTranscodedVideos(doc);
                return;
            }
            this.commitOrRollbackTransaction();
        }
        finally {
            this.cleanUp(true, null);
        }
        log.debug((Object)String.format("Processing %s conversion of Video document %s.", this.conversionName, doc));
        this.setStatus("Transcoding");
        VideoService service = (VideoService)Framework.getService(VideoService.class);
        TranscodedVideo transcodedVideo = service.convert(originalVideo, this.conversionName);
        this.startTransaction();
        this.setStatus("Saving");
        this.openSystemSession();
        doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        this.saveNewTranscodedVideo(doc, transcodedVideo);
        log.debug((Object)String.format("End processing %s conversion of Video document %s.", this.conversionName, doc));
        this.setStatus("Done");
    }

    public boolean isIdempotent() {
        return false;
    }

    public boolean isGroupJoin() {
        return true;
    }

    public String getPartitionKey() {
        return VideoConversionWork.computeIdPrefix(this.repositoryName, this.docId);
    }

    public void onGroupJoinCompletion() {
        this.fireVideoConversionsDoneEvent();
    }

    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals((Object)this, other);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.conversionName);
        return builder.toHashCode();
    }

    protected Video getVideoToConvert(DocumentModel doc) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        return videoDocument.getVideo();
    }

    protected void resetTranscodedVideos(DocumentModel doc) {
        log.warn((Object)String.format("No original video to transcode, resetting transcoded videos of document %s.", doc));
        this.setStatus("No video to process");
        doc.setPropertyValue("vid:transcodedVideos", null);
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(doc);
    }

    protected void saveNewTranscodedVideo(DocumentModel doc, TranscodedVideo transcodedVideo) {
        List<Map<String, Serializable>> transcodedVideos = (ArrayList<Map<String, Serializable>>)doc.getPropertyValue("vid:transcodedVideos");
        transcodedVideos = transcodedVideos == null ? new ArrayList<Map<String, Serializable>>() : transcodedVideos.stream().filter(map -> !transcodedVideo.getName().equals(map.get("name"))).collect(Collectors.toList());
        transcodedVideos.add(transcodedVideo.toMap());
        doc.setPropertyValue("vid:transcodedVideos", (Serializable)((Object)transcodedVideos));
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(doc);
    }

    protected void fireVideoConversionsDoneEvent() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(VIDEO_CONVERSIONS_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

