/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogConfig;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.log.chronicle.ChronicleCompoundLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogAppender;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogConfig;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogOffsetTracker;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.internals.AbstractLogManager;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;

public class ChronicleLogManager
extends AbstractLogManager {
    private static final Log log = LogFactory.getLog(ChronicleLogManager.class);
    protected final List<ChronicleLogConfig> configs;
    protected final ChronicleLogConfig defaultConfig;

    public ChronicleLogManager(Path basePath) {
        this(basePath, null);
    }

    public ChronicleLogManager(Path basePath, String retentionDuration) {
        this(Collections.singletonList(new ChronicleLogConfig("unknown", true, Collections.emptyList(), basePath, retentionDuration)));
    }

    public ChronicleLogManager(List<ChronicleLogConfig> configs) {
        this.configs = configs;
        this.defaultConfig = this.findDefaultConfig();
    }

    protected ChronicleLogConfig findDefaultConfig() {
        List defaultConfigs = this.configs.stream().filter(LogConfig::isDefault).collect(Collectors.toList());
        if (defaultConfigs.isEmpty()) {
            return this.configs.get(this.configs.size() - 1);
        }
        return (ChronicleLogConfig)defaultConfigs.get(defaultConfigs.size() - 1);
    }

    protected ChronicleLogConfig getConfig(Name name) {
        return this.configs.stream().filter(config -> config.match(name)).findFirst().orElse(this.defaultConfig);
    }

    protected ChronicleLogConfig getConfig(Name name, Name group) {
        return this.configs.stream().filter(config -> config.match(name, group)).findFirst().orElse(this.defaultConfig);
    }

    protected static void deleteQueueBasePath(Path basePath) {
        try {
            log.info((Object)("Removing Chronicle Queues directory: " + basePath));
            try (Stream<Path> paths = Files.list(basePath);){
                int count = (int)paths.filter(path -> path.toFile().isFile() && !ChronicleLogManager.isChronicleLogFile(path)).count();
                if (count > 0) {
                    String msg = "ChronicleLog basePath: " + basePath + " contains unknown files, please choose another basePath";
                    log.error((Object)msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            FileUtils.deleteDirectory((File)basePath.toFile());
        }
        catch (IOException e) {
            String msg = "Cannot remove Chronicle Queues directory: " + basePath + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected static boolean isChronicleLogFile(Path path) {
        String filename = path.getFileName().toString();
        return filename.endsWith(".cq4") || filename.endsWith(".cq4t") || "metadata.properties".equals(filename);
    }

    public String getBasePath() {
        return this.defaultConfig.getBasePath().toAbsolutePath().toString();
    }

    @Override
    public boolean exists(Name name) {
        boolean bl;
        block8: {
            ChronicleLogConfig config = this.getConfig(name);
            Stream<Path> paths = Files.list(config.getBasePath().resolve(name.getId()));
            try {
                boolean bl2 = bl = paths.count() > 0L;
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            paths.close();
        }
        return bl;
    }

    @Override
    public void create(Name name, int size) {
        ChronicleLogConfig config = this.getConfig(name);
        ChronicleLogAppender.create(config, name, size, NoCodec.NO_CODEC).close();
    }

    @Override
    protected int getSize(Name name) {
        ChronicleLogConfig config = this.getConfig(name);
        return ChronicleLogAppender.partitions(config.getBasePath().resolve(name.getId()));
    }

    @Override
    public boolean delete(Name name) {
        ChronicleLogConfig config = this.getConfig(name);
        Path path = config.getBasePath().resolve(name.getId());
        if (path.toFile().isDirectory()) {
            ChronicleLogManager.deleteQueueBasePath(path);
            return true;
        }
        return false;
    }

    protected LogLag getLagForPartition(Name name, int partition, Name group) {
        long pos;
        ChronicleLogConfig config = this.getConfig(name);
        Path path = config.getBasePath().resolve(name.getId());
        if (!ChronicleLogOffsetTracker.exists(path, group)) {
            pos = 0L;
        } else {
            try (ChronicleLogOffsetTracker offsetTracker = new ChronicleLogOffsetTracker(path.toString(), partition, group, ChronicleRetentionDuration.disableOf(config.getRetention()));){
                pos = offsetTracker.readLastCommittedOffset();
            }
        }
        try (ChronicleLogAppender appender = ChronicleLogAppender.openWithoutRetention(config, name, NoCodec.NO_CODEC);){
            long end = appender.endOffset(partition);
            if (pos == 0L) {
                pos = appender.firstOffset(partition);
            }
            long lag = appender.countMessages(partition, pos, end);
            long firstOffset = appender.firstOffset(partition);
            long endMessages = appender.countMessages(partition, firstOffset, end);
            LogLag logLag = new LogLag(pos, end, lag, endMessages);
            return logLag;
        }
    }

    @Override
    public List<LogLag> getLagPerPartition(Name name, Name group) {
        int size = this.size(name);
        ArrayList<LogLag> ret = new ArrayList<LogLag>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.getLagForPartition(name, i, group));
        }
        return ret;
    }

    public String toString() {
        return "ChronicleLogManager{configs=" + this.configs + ", defaultConfig=" + this.defaultConfig + "}";
    }

    @Override
    public List<Name> listAllNames() {
        HashSet names = new HashSet();
        for (ChronicleLogConfig config : this.configs) {
            try {
                Stream<Path> paths = Files.list(config.getBasePath());
                try {
                    paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).forEach(name -> names.add(Name.ofId(name)));
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                log.info((Object)("Nothing to list in CQ config: " + config));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Invalid log name in " + config.getBasePath()), (Throwable)e);
                throw e;
            }
        }
        return new ArrayList<Name>(names);
    }

    @Override
    public List<Name> listConsumerGroups(Name name) {
        List<Name> list;
        block9: {
            ChronicleLogConfig config = this.getConfig(name);
            Path logRoot = config.getBasePath().resolve(name.getId());
            if (!logRoot.toFile().exists()) {
                throw new IllegalArgumentException("Unknown Log: " + name);
            }
            Stream<Path> paths = Files.list(logRoot);
            try {
                list = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(ChronicleLogOffsetTracker::isOffsetTracker).map(ChronicleLogOffsetTracker::getGroupFromDirectory).map(Name::ofId).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot access Log: " + name, e);
                }
            }
            paths.close();
        }
        return list;
    }

    @Override
    public <M extends Externalizable> CloseableLogAppender<M> createAppender(Name name, Codec<M> codec) {
        ChronicleLogConfig config = this.getConfig(name);
        return ChronicleLogAppender.open(config, name, codec);
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doCreateTailer(Collection<LogPartition> partitions, Name group, Codec<M> codec) {
        ArrayList pTailers = new ArrayList(partitions.size());
        partitions.forEach(partition -> pTailers.add((ChronicleLogTailer)((ChronicleLogAppender)this.getAppender(partition.name(), codec)).createTailer((LogPartition)partition, group, codec)));
        if (pTailers.size() == 1) {
            return (LogTailer)pTailers.iterator().next();
        }
        return new ChronicleCompoundLogTailer(pTailers, group);
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doSubscribe(Name group, Collection<Name> names, RebalanceListener listener, Codec<M> codec) {
        throw new UnsupportedOperationException("subscribe is not supported by Chronicle implementation");
    }
}

