/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.internals;

import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.Name;

public class LogPartitionGroup {
    public final Name group;
    public final Name name;
    public final int partition;

    public LogPartitionGroup(Name group, LogPartition mqp) {
        this.group = group;
        this.name = mqp.name();
        this.partition = mqp.partition();
    }

    public LogPartitionGroup(Name group, Name name, int partition) {
        this.group = group;
        this.name = name;
        this.partition = partition;
    }

    public LogPartition getLogPartition() {
        return LogPartition.of(this.name, this.partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPartitionGroup that = (LogPartitionGroup)o;
        return this.partition == that.partition && (this.group != null ? this.group.equals(that.group) : that.group == null) && (this.name != null ? this.name.equals(that.name) : that.name == null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.partition;
        return result;
    }

    public String toString() {
        return String.format("%s:%s-%02d", this.group.getUrn(), this.name.getUrn(), this.partition);
    }
}

