/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.stream.DomainEventProducer;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.stream.AuditDomainEvent;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;

public class AuditDomainEventProducer
extends DomainEventProducer {
    protected static final Logger log = LogManager.getLogger(AuditDomainEventProducer.class);
    protected static final String SOURCE_NAME = "ADEP";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final String CODEC_NAME = "avroBinary";
    protected final List<Record> records = new ArrayList<Record>();
    protected final Codec<AuditDomainEvent> codec = ((CodecService)Framework.getService(CodecService.class)).getCodec("avroBinary", AuditDomainEvent.class);

    public AuditDomainEventProducer(String name, String stream) {
        super(name, stream);
    }

    public void addEvent(Event event) {
        LogEntry entry;
        AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
        if (logger == null || event == null) {
            return;
        }
        if (logger.getAuditableEventNames().contains(event.getName()) && (entry = logger.buildEntryFromEvent(event)) != null) {
            this.records.add(this.buildRecordFromEvent(entry));
        }
    }

    protected Record buildRecordFromEvent(LogEntry entry) {
        Map extended;
        AuditDomainEvent event = new AuditDomainEvent();
        event.source = SOURCE_NAME;
        event.name = entry.getEventId();
        event.category = entry.getCategory();
        event.docId = entry.getDocUUID();
        event.docRepository = entry.getRepositoryId();
        event.principalName = entry.getPrincipalName();
        event.docLifeCycle = entry.getDocLifeCycle();
        event.docType = entry.getDocType();
        event.docPath = entry.getDocPath();
        event.comment = entry.getComment();
        if (entry.getEventDate() != null) {
            event.date = entry.getEventDate().getTime();
        }
        if ((extended = entry.getExtendedInfos()) != null && !extended.isEmpty()) {
            try {
                event.extendedInfoAsJson = MAPPER.writeValueAsString((Object)extended);
            }
            catch (JsonProcessingException e) {
                log.error("Skip invalid extended info: {}", (Object)event, (Object)e);
            }
        }
        log.debug("event {} -> {}", (Object)entry, (Object)event);
        return Record.of((String)event.name, (byte[])this.codec.encode((Object)event));
    }

    public List<Record> getDomainEvents() {
        return this.records;
    }
}

