/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.automation.core.scripting.Scripting;

public class OperationParameters
implements Serializable {
    private static final long serialVersionUID = -3215180388563955264L;
    protected final String oid;
    protected final Map<String, Object> params = new HashMap<String, Object>();

    public OperationParameters(String oid) {
        this.oid = oid;
    }

    public OperationParameters(String oid, Map<String, Object> params) {
        this(oid);
        this.params.putAll(params);
    }

    public String id() {
        return this.oid;
    }

    public final Map<String, Object> map() {
        return this.params;
    }

    public OperationParameters set(String key, Object valueRef) {
        if (valueRef instanceof String && ((String)valueRef).startsWith("expr:")) {
            valueRef = ((String)valueRef).substring(5).trim();
            if (((String)(valueRef = StringEscapeUtils.unescapeXml((String)((String)valueRef)))).contains("@{")) {
                this.params.put(key, Scripting.newTemplate((String)valueRef));
            } else {
                this.params.put(key, Scripting.newExpression((String)valueRef));
            }
            return this;
        }
        this.params.put(key, valueRef);
        return this;
    }

    public OperationParameters from(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.oid.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationParameters)) {
            return false;
        }
        OperationParameters other = (OperationParameters)obj;
        if (!this.oid.equals(other.oid)) {
            return false;
        }
        return this.params.equals(other.params);
    }
}

