/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;

public class AbstractOperationMultiValuedProperty {
    protected void checkFieldType(Type type, Object value) throws OperationException {
        if (!type.isListType()) {
            throw new OperationException("Only multivalued types can be set using this operation");
        }
        ListType listType = (ListType)type;
        Type itemType = listType.getFieldType();
        if (itemType.isComplexType()) {
            throw new UnsupportedOperationException("Manage only lists of scalar items");
        }
        try {
            if (itemType.convert(value) == null) {
                String exceptionReason = String.format("Given type \"%s\" value is not a %s type", value, itemType.getName());
                throw new UnsupportedOperationException(exceptionReason);
            }
        }
        catch (ClassCastException | TypeException e) {
            String exceptionReason = String.format("Given type \"%s\" value is not a %s type", value, itemType.getName());
            throw new OperationException(exceptionReason, e);
        }
    }
}

