/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.runtime.api.Framework;

public class JSONManagedBlobDecoder
implements JSONBlobDecoder {
    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        if (!jsonObject.has("providerId") || !jsonObject.has("key")) {
            return null;
        }
        String providerId = jsonObject.get("providerId").textValue();
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(providerId);
        if (blobProvider == null) {
            return null;
        }
        if (!blobProvider.hasCreateFromKeyPermission()) {
            throw new NuxeoException("The current user does not have the rights to fetch the blob", 401);
        }
        try {
            BlobInfo blobInfo = new BlobInfo();
            blobInfo.key = providerId + ":" + jsonObject.get("key").textValue();
            return blobProvider.readBlob(blobInfo);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

