/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.function.Supplier;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LockHelper {
    public static final String DOCUMENT_LOCK = "document-lock";
    public static final String LOCK = "lock";
    public static final int NB_TRY = 3;
    public static final int SLEEP_DURATION = 1000;

    private LockHelper() {
    }

    public static void doAtomically(String key, Runnable runnable) throws ConcurrentUpdateException {
        LockHelper.doAtomically(key, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <R> R doAtomically(String key, Supplier<R> supplier) throws ConcurrentUpdateException {
        R r;
        KeyValueStore kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(DOCUMENT_LOCK);
        if (!LockHelper.tryLock(key, kvStore)) throw new ConcurrentUpdateException("Failed to acquire the lock on key " + key);
        try {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            r = supplier.get();
        }
        catch (Throwable throwable) {
            try {
                try {
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                    throw throwable;
                }
                finally {
                    LockHelper.unlock(key, kvStore);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException(e);
            }
        }
        try {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            return r;
        }
        finally {
            LockHelper.unlock(key, kvStore);
        }
    }

    protected static boolean tryLock(String key, KeyValueStore kvStore) throws InterruptedException {
        long sleepDuration = 1000L;
        for (int i = 0; i < 3; ++i) {
            if (kvStore.compareAndSet(key, null, LOCK)) {
                return true;
            }
            Thread.sleep(sleepDuration);
            sleepDuration *= 2L;
        }
        return false;
    }

    protected static void unlock(String key, KeyValueStore kvStore) {
        kvStore.put(key, (String)null);
    }
}

