/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class NuxeoException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private LinkedList<String> infos;
    protected int statusCode = 500;

    public NuxeoException() {
    }

    public NuxeoException(int statusCode) {
        this.statusCode = statusCode;
    }

    public NuxeoException(String message) {
        super(message);
    }

    public NuxeoException(String message, int statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public NuxeoException(String message, Throwable cause) {
        super(message, cause);
    }

    public NuxeoException(String message, Throwable cause, int statusCode) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public NuxeoException(Throwable cause) {
        super(cause);
    }

    public NuxeoException(Throwable cause, int statusCode) {
        super(cause);
        this.statusCode = statusCode;
    }

    public NuxeoException addInfo(String info) {
        if (this.infos == null) {
            this.infos = new LinkedList();
        }
        this.infos.addFirst(info);
        return this;
    }

    public List<String> getInfos() {
        return this.infos == null ? Collections.emptyList() : this.infos;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String message = this.getOriginalMessage();
        if (this.infos == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        for (String info : this.infos) {
            sb.append(info);
            sb.append(", ");
        }
        sb.append(message);
        return sb.toString();
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

