/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class BlobsExtractor {
    protected final Map<String, List<String>> docBlobPaths = new ConcurrentHashMap<String, List<String>>();
    private Set<String> includedPaths;
    private Set<String> excludedPaths;
    private boolean allBlobs;
    private boolean isDefaultConfiguration = true;

    public void setExtractorProperties(Set<String> includedPaths, Set<String> excludedPaths, boolean allBlobs) {
        this.includedPaths = this.normalizePaths(includedPaths);
        this.excludedPaths = this.normalizePaths(excludedPaths);
        this.allBlobs = allBlobs;
        this.isDefaultConfiguration = includedPaths == null && excludedPaths == null && allBlobs;
    }

    protected boolean isInterestingPath(String path) {
        if (this.isDefaultConfiguration) {
            return true;
        }
        if (this.excludedPaths != null && this.excludedPaths.contains(path)) {
            return false;
        }
        if (this.includedPaths != null && this.includedPaths.contains(path)) {
            return true;
        }
        return this.allBlobs;
    }

    /*
     * WARNING - void declaration
     */
    protected Set<String> normalizePaths(Set<String> paths) {
        if (paths == null) {
            return null;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        HashSet<String> normPaths = new HashSet<String>();
        for (String string : paths) {
            void var5_5;
            void var5_8;
            if (string.endsWith("/data")) {
                String string2 = string.substring(0, string.length() - "/data".length());
            }
            if (schemaManager.getField((String)var5_8) == null && !var5_8.contains(":")) {
                int slash = var5_8.indexOf(47);
                void first = slash == -1 ? var5_8 : var5_8.substring(0, slash);
                for (Schema schema : schemaManager.getSchemas()) {
                    if (schema.getNamespace().hasPrefix() || schema.getField((String)first) == null) continue;
                    String string3 = schema.getName() + ":" + (String)var5_8;
                    break;
                }
            }
            normPaths.add((String)var5_5);
        }
        return normPaths;
    }

    public List<Blob> getBlobs(DocumentModel doc) {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (Property property : this.getBlobsProperties(doc)) {
            blobs.add((Blob)((Object)property.getValue()));
        }
        return blobs;
    }

    public List<Property> getBlobsProperties(DocumentModel doc) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (String path : this.getBlobPaths(doc.getDocumentType())) {
            if (!this.isInterestingPath(path)) continue;
            List<String> split = Arrays.asList(path.split("/[*]/|/"));
            if (split.isEmpty()) {
                throw new IllegalStateException("Path detected not well-formed: " + path);
            }
            Property property = doc.getProperty(split.get(0));
            List<String> subPath = split.subList(1, split.size());
            this.findBlobsProperties(property, subPath, properties);
        }
        return properties;
    }

    public List<String> getBlobPaths(DocumentType documentType) {
        String docType = documentType.getName();
        List<String> paths = this.docBlobPaths.get(docType);
        if (paths == null) {
            paths = new ArrayList<String>();
            for (Schema schema : documentType.getSchemas()) {
                this.findBlobPaths((ComplexType)schema, null, schema, paths);
            }
            this.docBlobPaths.put(docType, paths);
        }
        return paths;
    }

    protected void findBlobsProperties(Property property, List<String> split, List<Property> properties) {
        if (split.isEmpty()) {
            if (property.getValue() != null) {
                properties.add(property);
            }
        } else {
            String name = split.get(0);
            List<String> subPath = split.subList(1, split.size());
            if (property.isList()) {
                for (Property childProperty : property.getChildren()) {
                    Property childSubProp = childProperty.get(name);
                    this.findBlobsProperties(childSubProp, subPath, properties);
                }
            } else {
                Property childSubProp = property.get(name);
                this.findBlobsProperties(childSubProp, subPath, properties);
            }
        }
    }

    protected void findBlobPaths(ComplexType complexType, String path, Schema schema, List<String> paths) {
        for (Field field : complexType.getFields()) {
            Type type;
            Object fieldPath = field.getName().getPrefixedName();
            if (path == null) {
                if (!schema.getNamespace().hasPrefix()) {
                    fieldPath = schema.getName() + ":" + (String)fieldPath;
                }
            } else {
                fieldPath = path + "/" + (String)fieldPath;
            }
            if ((type = field.getType()).isSimpleType()) continue;
            if (type.isListType()) {
                Type fieldType = ((ListType)type).getFieldType();
                if (!fieldType.isComplexType()) continue;
                this.findBlobPaths((ComplexType)fieldType, (String)fieldPath + "/*", schema, paths);
                continue;
            }
            ComplexType ctype = (ComplexType)type;
            if (TypeConstants.isContentType((Type)type)) {
                paths.add((String)fieldPath);
                continue;
            }
            this.findBlobPaths(ctype, (String)fieldPath, schema, paths);
        }
    }
}

