/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.jwt.JWTService;
import org.nuxeo.ecm.platform.oauth2.OAuth2Error;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.request.AuthorizationRequest;
import org.nuxeo.ecm.platform.oauth2.request.TokenRequest;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth2Servlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoOAuth2Servlet.class);
    public static final String ENDPOINT_AUTH = "authorize";
    public static final String ENDPOINT_TOKEN = "token";
    public static final String ENDPOINT_AUTH_SUBMIT = "authorize_submit";
    public static final String ERROR_PARAM = "error";
    public static final String ERROR_DESCRIPTION_PARAM = "error_description";
    public static final String CLIENT_NAME = "client_name";
    public static final String GRANT_JSP_PAGE_PATH = "/oauth2Grant.jsp";
    public static final String GRANT_ACCESS_PARAM = "grant_access";
    public static final String ERROR_JSP_PAGE_PATH = "/oauth2error.jsp";
    public static final int ACCESS_TOKEN_EXPIRATION_TIME = 3600000;
    protected final OAuth2TokenStore tokenStore = new OAuth2TokenStore("org.nuxeo.server.token.store");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(ENDPOINT_AUTH)) {
            this.doGetAuthorize(request, response);
        } else if (pathInfo.endsWith(ENDPOINT_AUTH_SUBMIT)) {
            this.doGetNotAllowed(ENDPOINT_AUTH_SUBMIT, request, response);
        } else if (pathInfo.endsWith(ENDPOINT_TOKEN)) {
            this.doGetNotAllowed(ENDPOINT_TOKEN, request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(ENDPOINT_AUTH_SUBMIT)) {
            this.doPostAuthorizeSubmit(request, response);
        } else if (pathInfo.endsWith(ENDPOINT_TOKEN)) {
            this.doPostToken(request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doGetAuthorize(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String state;
        String scope;
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        AuthorizationRequest authRequest = AuthorizationRequest.fromRequest(request);
        OAuth2Error error = authRequest.checkError();
        if (error != null) {
            this.handleError(error, request, response);
            return;
        }
        String clientId = authRequest.getClientId();
        OAuth2Client client = clientService.getClient(clientId);
        if (client.isAutoGrant() || this.tokenStore.getToken(clientId, authRequest.getUsername()) != null) {
            String redirectURI = this.getRedirectURI(authRequest);
            String authorizationCode = this.storeAuthorizationRequest(authRequest);
            String state2 = request.getParameter("state");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("code", authorizationCode);
            if (StringUtils.isNotBlank((CharSequence)state2)) {
                params.put("state", state2);
            }
            this.sendRedirect(request, response, redirectURI, params);
            return;
        }
        request.setAttribute("response_type", (Object)authRequest.getResponseType());
        request.setAttribute("client_id", (Object)clientId);
        String redirectURI = authRequest.getRedirectURI();
        if (StringUtils.isNotBlank((CharSequence)redirectURI)) {
            request.setAttribute("redirect_uri", (Object)redirectURI);
        }
        if (StringUtils.isNotBlank((CharSequence)(scope = authRequest.getScope()))) {
            request.setAttribute("scope", (Object)scope);
        }
        if (StringUtils.isNotBlank((CharSequence)(state = request.getParameter("state")))) {
            request.setAttribute("state", (Object)state);
        }
        String codeChallenge = authRequest.getCodeChallenge();
        String codeChallengeMethod = authRequest.getCodeChallengeMethod();
        if (codeChallenge != null && codeChallengeMethod != null) {
            request.setAttribute("code_challenge", (Object)codeChallenge);
            request.setAttribute("code_challenge_method", (Object)codeChallengeMethod);
        }
        request.setAttribute(CLIENT_NAME, (Object)client.getName());
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(GRANT_JSP_PAGE_PATH);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doGetNotAllowed(String endpoint, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OAuth2Error error = OAuth2Error.invalidRequest(String.format("The /oauth2/%s endpoint only accepts POST requests.", endpoint));
        this.handleError(error, 405, request, response);
    }

    protected void doPostAuthorizeSubmit(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AuthorizationRequest authRequest = AuthorizationRequest.fromRequest(request);
        OAuth2Error error = authRequest.checkError();
        if (error != null) {
            this.handleError(error, request, response);
            return;
        }
        String redirectURI = this.getRedirectURI(authRequest);
        String state = request.getParameter("state");
        String grantAccess = request.getParameter(GRANT_ACCESS_PARAM);
        if (grantAccess == null) {
            error = OAuth2Error.accessDenied("Access denied by the user");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(ERROR_PARAM, error.getId());
            String errorDescription = error.getDescription();
            if (StringUtils.isNotBlank((CharSequence)errorDescription)) {
                params.put(ERROR_DESCRIPTION_PARAM, errorDescription);
            }
            if (StringUtils.isNotBlank((CharSequence)state)) {
                params.put("state", state);
            }
            this.sendRedirect(request, response, redirectURI, params);
            return;
        }
        String authorizationCode = this.storeAuthorizationRequest(authRequest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authorizationCode);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            params.put("state", state);
        }
        this.sendRedirect(request, response, redirectURI, params);
    }

    protected String getRedirectURI(AuthorizationRequest authRequest) {
        String redirectURI = authRequest.getRedirectURI();
        if (StringUtils.isBlank((CharSequence)redirectURI)) {
            return ((OAuth2ClientService)Framework.getService(OAuth2ClientService.class)).getClient(authRequest.getClientId()).getRedirectURIs().get(0);
        }
        return redirectURI;
    }

    protected String storeAuthorizationRequest(AuthorizationRequest authRequest) {
        String authorizationCode = authRequest.getAuthorizationCode();
        AuthorizationRequest.store(authorizationCode, authRequest);
        return authorizationCode;
    }

    protected void doPostToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TokenRequest tokenRequest = new TokenRequest(request);
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        String grantType = tokenRequest.getGrantType();
        if ("authorization_code".equals(grantType)) {
            String authorizationCode = tokenRequest.getCode();
            AuthorizationRequest authRequest = AuthorizationRequest.get(authorizationCode);
            String clientId = tokenRequest.getClientId();
            OAuth2Error error = null;
            if (authRequest == null) {
                error = OAuth2Error.invalidGrant("Invalid authorization code");
            } else if (!authRequest.getClientId().equals(clientId)) {
                error = OAuth2Error.invalidClient(String.format("Invalid client id: %s", clientId));
            } else {
                OAuth2Client client = clientService.getClient(clientId);
                if (client == null || !client.isValidWith(tokenRequest.getClientId(), tokenRequest.getClientSecret())) {
                    error = OAuth2Error.invalidClient("Disabled client or invalid client secret");
                } else {
                    String authRequestRedirectURI = authRequest.getRedirectURI();
                    String tokenRequestRedirectURI = tokenRequest.getRedirectURI();
                    if (StringUtils.isNotBlank((CharSequence)authRequestRedirectURI) && !authRequestRedirectURI.equals(tokenRequestRedirectURI)) {
                        error = OAuth2Error.invalidGrant(String.format("Invalid redirect URI: %s", tokenRequestRedirectURI));
                    } else {
                        String codeChallenge = authRequest.getCodeChallenge();
                        if (codeChallenge != null) {
                            String codeVerifier = tokenRequest.getCodeVerifier();
                            if (codeVerifier == null) {
                                error = OAuth2Error.invalidRequest(String.format("Missing %s parameter", "code_verifier"));
                            } else if (!authRequest.isCodeVerifierValid(codeVerifier)) {
                                error = OAuth2Error.invalidGrant(String.format("Invalid %s parameter", "code_verifier"));
                            }
                        }
                    }
                }
            }
            if (authRequest != null) {
                AuthorizationRequest.remove(authorizationCode);
            }
            if (error != null) {
                this.handleJsonError(error, response);
                return;
            }
            String username = authRequest.getUsername();
            this.getAndSendToken(response, clientId, username);
        } else if ("refresh_token".equals(grantType)) {
            OAuth2Error error = null;
            if (StringUtils.isBlank((CharSequence)tokenRequest.getClientId())) {
                error = OAuth2Error.invalidRequest("Empty client id");
            } else if (!clientService.isValidClient(tokenRequest.getClientId(), tokenRequest.getClientSecret())) {
                error = OAuth2Error.invalidClient("Disabled client or invalid client secret");
            }
            if (error != null) {
                this.handleJsonError(error, response);
                return;
            }
            NuxeoOAuth2Token refreshed = (NuxeoOAuth2Token)TransactionHelper.runInTransaction(() -> this.tokenStore.refresh(tokenRequest.getRefreshToken(), tokenRequest.getClientId()));
            if (refreshed == null) {
                this.handleJsonError(OAuth2Error.invalidGrant("Cannot refresh token"), response);
            } else {
                this.handleTokenResponse(refreshed, response);
            }
        } else if ("urn:ietf:params:oauth:grant-type:jwt-bearer".equals(grantType)) {
            String jwtToken = tokenRequest.getAssertion();
            String clientId = tokenRequest.getClientId();
            String clientSecret = tokenRequest.getClientSecret();
            OAuth2Error error = null;
            if (StringUtils.isBlank((CharSequence)jwtToken)) {
                error = OAuth2Error.invalidRequest("Empty assertion");
            } else if (StringUtils.isBlank((CharSequence)clientId)) {
                error = OAuth2Error.invalidRequest("Empty client id");
            } else if (!clientService.hasClient(clientId)) {
                error = OAuth2Error.invalidClient(String.format("Invalid client: %s", clientId));
            } else if (!clientService.isValidClient(clientId, clientSecret)) {
                error = OAuth2Error.invalidClient(String.format("Disabled client: %s or invalid client secret", clientId));
            }
            if (error != null) {
                this.handleJsonError(error, response);
                return;
            }
            Map claims = ((JWTService)Framework.getService(JWTService.class)).verifyToken(jwtToken);
            if (claims == null) {
                error = OAuth2Error.invalidClient("Secret not configured or invalid token");
                this.handleJsonError(error, response);
                return;
            }
            String username = (String)claims.get("sub");
            this.getAndSendToken(response, clientId, username);
        } else {
            this.handleJsonError(OAuth2Error.unsupportedGrantType(String.format("Unknown %s: got \"%s\", expecting \"%s\", \"%s\" or \"%s\".", "grant_type", grantType, "authorization_code", "refresh_token", "urn:ietf:params:oauth:grant-type:jwt-bearer")), response);
        }
    }

    protected void getAndSendToken(HttpServletResponse response, String clientId, String username) throws IOException {
        NuxeoOAuth2Token token = this.tokenStore.getToken(clientId, username);
        if (token == null) {
            NuxeoOAuth2Token newToken = new NuxeoOAuth2Token(3600000L, clientId);
            TransactionHelper.runInTransaction(() -> this.tokenStore.store(username, newToken));
            token = newToken;
        } else if (token.isExpired()) {
            String refreshToken = token.getRefreshToken();
            token = (NuxeoOAuth2Token)TransactionHelper.runInTransaction(() -> this.tokenStore.refresh(refreshToken, clientId));
        }
        this.handleTokenResponse(token, response);
    }

    protected void handleTokenResponse(NuxeoOAuth2Token token, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "application/json");
        response.setStatus(200);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)response.getWriter(), token.toJsonObject());
    }

    protected void handleError(OAuth2Error error, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handleError(error, 400, request, response);
    }

    protected void handleError(OAuth2Error error, int status, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.warn((Object)String.format("OAuth2 authorization request error: %s", error));
        response.reset();
        response.setStatus(status);
        request.setAttribute(ERROR_PARAM, (Object)error);
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(ERROR_JSP_PAGE_PATH);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void handleJsonError(OAuth2Error error, HttpServletResponse response) throws IOException {
        log.warn((Object)String.format("OAuth2 token request error: %s", error));
        response.setHeader("Content-Type", "application/json");
        response.setStatus(400);
        HashMap<String, String> object = new HashMap<String, String>();
        object.put(ERROR_PARAM, error.getId());
        if (StringUtils.isNotBlank((CharSequence)error.getDescription())) {
            object.put(ERROR_DESCRIPTION_PARAM, error.getDescription());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)response.getWriter(), object);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectURI, Map<String, String> params) throws IOException {
        if (redirectURI == null) {
            response.sendError(400, "No redirect URI");
            return;
        }
        String url = URIUtils.addParametersToURIQuery((String)redirectURI, params);
        response.sendRedirect(url);
    }
}

