/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class Maths
extends Enum<Maths> {
    private static final double WHOLE_NUMBER = 4.503599627370496E15;
    private static final int K0 = 1829709757;
    private static final int M0 = 1539836845;
    private static final int M1 = -361396777;
    private static final int M2 = 2053402137;
    private static final int M3 = -2057448229;
    private static final long[] TENS;
    private static final long[] FIVES;
    private static final /* synthetic */ Maths[] $VALUES;

    public static Maths[] values() {
        return (Maths[])$VALUES.clone();
    }

    public static Maths valueOf(String name) {
        return Enum.valueOf(Maths.class, name);
    }

    public static double roundN(double d, int digits) {
        long factor = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? (double)((long)(d < 0.0 ? d * (double)factor - 0.5 : d * (double)factor + 0.5)) / (double)factor : d;
    }

    public static long roundingFactor(int digits) {
        return TENS[digits];
    }

    public static long roundingFactor(double digits) {
        int iDigits = (int)digits;
        long ten = TENS[iDigits];
        switch ((int)((digits - (double)iDigits) * 10.0 + 0.5)) {
            case 0: 
            case 1: 
            case 2: {
                return ten;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2L * ten;
            }
            case 6: {
                return 4L * ten;
            }
            case 7: 
            case 8: {
                return 5L * ten;
            }
            case 9: {
                return 8L * ten;
            }
        }
        return 10L * ten;
    }

    public static double ceilN(double d, int digits) {
        long factor = Maths.roundingFactor(digits + 8);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.ceil((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double floorN(double d, int digits) {
        long factor = Maths.roundingFactor(digits + 8);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.floor((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double roundN(double d, double digits) {
        long factor = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? (double)((long)(d < 0.0 ? d * (double)factor - 0.5 : d * (double)factor + 0.5)) / (double)factor : d;
    }

    public static double ceilN(double d, double digits) {
        long factor = Maths.roundingFactor(digits + 8.0);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.ceil((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double floorN(double d, double digits) {
        long factor = Maths.roundingFactor(digits + 8.0);
        long factor2 = Maths.roundingFactor(digits);
        return Math.abs(d) < 4.503599627370496E15 / (double)factor ? Math.floor((double)Math.round(d * (double)factor) / 1.0E8) / (double)factor2 : d;
    }

    public static double round1(double d) {
        double factor = 10.0;
        return Math.abs(d) < 4.503599627370496E14 ? (double)((long)(d < 0.0 ? d * 10.0 - 0.5 : d * 10.0 + 0.5)) / 10.0 : d;
    }

    public static double round2(double d) {
        double factor = 100.0;
        return Math.abs(d) < 4.503599627370496E13 ? (double)((long)(d < 0.0 ? d * 100.0 - 0.5 : d * 100.0 + 0.5)) / 100.0 : d;
    }

    public static double round3(double d) {
        double factor = 1000.0;
        return Math.abs(d) < 4.503599627370496E12 ? (double)((long)(d < 0.0 ? d * 1000.0 - 0.5 : d * 1000.0 + 0.5)) / 1000.0 : d;
    }

    public static double round4(double d) {
        double factor = 10000.0;
        return Math.abs(d) < 4.503599627370496E11 ? (double)((long)(d < 0.0 ? d * 10000.0 - 0.5 : d * 10000.0 + 0.5)) / 10000.0 : d;
    }

    public static double round5(double d) {
        double factor = 100000.0;
        return Math.abs(d) < 4.503599627370496E10 ? (double)((long)(d < 0.0 ? d * 100000.0 - 0.5 : d * 100000.0 + 0.5)) / 100000.0 : d;
    }

    public static double round6(double d) {
        double factor = 1000000.0;
        return Math.abs(d) < 4.503599627370496E9 ? (double)((long)(d < 0.0 ? d * 1000000.0 - 0.5 : d * 1000000.0 + 0.5)) / 1000000.0 : d;
    }

    public static double round7(double d) {
        double factor = 1.0E7;
        return Math.abs(d) < 4.503599627370496E8 ? (double)((long)(d < 0.0 ? d * 1.0E7 - 0.5 : d * 1.0E7 + 0.5)) / 1.0E7 : d;
    }

    public static double round8(double d) {
        double factor = 1.0E8;
        return Math.abs(d) < 4.503599627370496E7 ? (double)((long)(d < 0.0 ? d * 1.0E8 - 0.5 : d * 1.0E8 + 0.5)) / 1.0E8 : d;
    }

    public static int nextPower2(int n, int min) throws IllegalArgumentException {
        return (int)Math.min(0x40000000L, Maths.nextPower2((long)n, (long)min));
    }

    public static long nextPower2(long n, long min) throws IllegalArgumentException {
        if (!Maths.isPowerOf2(min)) {
            throw new IllegalArgumentException(min + " must be a power of 2");
        }
        if (n < min) {
            return min;
        }
        if (Maths.isPowerOf2(n)) {
            return n;
        }
        long i = min;
        while (i < n) {
            if ((i *= 2L) > 0L) continue;
            return 0x4000000000000000L;
        }
        return i;
    }

    public static boolean isPowerOf2(long n) {
        return Long.bitCount(n) == 1;
    }

    public static int hash32(@NotNull CharSequence cs) {
        long h = Maths.hash64(cs);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(@NotNull String s) {
        long h = Maths.hash64(s);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(@NotNull StringBuilder s) {
        long h = Maths.hash64(s);
        h ^= h >> 32;
        return (int)h;
    }

    public static int hash32(long l0) {
        long h = Maths.hash64(l0);
        h ^= h >> 32;
        return (int)h;
    }

    public static long hash64(@NotNull CharSequence cs) {
        if (cs instanceof String) {
            return Maths.hash64((String)cs);
        }
        long hash = 0L;
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            hash = hash * 841248317L + (long)cs.charAt(i);
        }
        return Maths.agitate(hash);
    }

    public static long hash64(@NotNull String s) {
        long hash = 0L;
        if (Jvm.isJava9Plus()) {
            byte[] bytes = StringUtils.extractBytes(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                hash = hash * 841248317L + (long)bytes[i];
            }
        } else {
            char[] chars = StringUtils.extractChars(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                hash = hash * 841248317L + (long)chars[i];
            }
        }
        return Maths.agitate(hash);
    }

    public static long hash64(@NotNull StringBuilder s) {
        long hash = 0L;
        if (Jvm.isJava9Plus()) {
            byte[] bytes = StringUtils.extractBytes(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                hash = hash * 841248317L + (long)bytes[i];
            }
        } else {
            char[] chars = StringUtils.extractChars(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                hash = hash * 841248317L + (long)chars[i];
            }
        }
        return Maths.agitate(hash);
    }

    public static int intLog2(long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("positive argument expected, " + num + " given");
        }
        return 63 - Long.numberOfLeadingZeros(num);
    }

    public static byte toInt8(long x) throws IllegalArgumentException {
        if ((long)((byte)x) == x) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Byte " + x + " out of range");
    }

    public static short toInt16(long x) throws IllegalArgumentException {
        if ((long)((short)x) == x) {
            return (short)x;
        }
        throw new IllegalArgumentException("Short " + x + " out of range");
    }

    public static int toInt32(long x, @NotNull String msg) throws IllegalArgumentException {
        if ((long)((int)x) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException(String.format(msg, x));
    }

    public static int toInt32(long x) throws IllegalArgumentException {
        if ((long)((int)x) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Int " + x + " out of range");
    }

    public static short toUInt8(long x) throws IllegalArgumentException {
        if ((x & 0xFFL) == x) {
            return (short)x;
        }
        throw new IllegalArgumentException("Unsigned Byte " + x + " out of range");
    }

    public static int toUInt16(long x) throws IllegalArgumentException {
        if ((x & 0xFFFFL) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Unsigned Short " + x + " out of range");
    }

    public static int toUInt31(long x) throws IllegalArgumentException {
        if ((x & Integer.MAX_VALUE) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Unsigned Int 31-bit " + x + " out of range");
    }

    public static long toUInt32(long x) throws IllegalArgumentException {
        if ((x & 0xFFFFFFFFL) == x) {
            return x;
        }
        throw new IllegalArgumentException("Unsigned Int " + x + " out of range");
    }

    public static long agitate(long l) {
        l += l >>> 22;
        l ^= Long.rotateRight(l, 17);
        return l;
    }

    public static long hash64(long l0) {
        int l0a = (int)(l0 >> 32);
        long h0 = l0 * 1539836845L + (long)(l0a * -361396777);
        return Maths.agitate(h0);
    }

    public static long hash64(long l0, long l1) {
        int l0a = (int)(l0 >> 32);
        int l1a = (int)(l1 >> 32);
        long h0 = (l0 + (long)l1a) * 1539836845L;
        long h1 = (l1 + (long)l0a) * -361396777L;
        return Maths.agitate(h0) ^ Maths.agitate(h1);
    }

    public static long divideRoundUp(long dividend, long divisor) {
        int sign = (dividend > 0L ? 1 : -1) * (divisor > 0L ? 1 : -1);
        return (long)sign * (Math.abs(dividend) + Math.abs(divisor) - 1L) / Math.abs(divisor);
    }

    public static long tens(int decimalPlaces) {
        return TENS[decimalPlaces];
    }

    public static int digits(long num) {
        int index = Arrays.binarySearch(TENS, num);
        return index < -1 ? -1 - index : (index >= 0 ? index + 1 : 1);
    }

    public static long fives(int decimalPlaces) {
        return FIVES[decimalPlaces];
    }

    public static boolean same(double a, double b) {
        return Double.isNaN(a) ? Double.isNaN(b) : a == b;
    }

    public static boolean same(float a, float b) {
        return Float.isNaN(a) ? Float.isNaN(b) : a == b;
    }

    public static int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hash(Object o1, Object o2) {
        return Maths.hash(o1) * 1539836845 + Maths.hash(o2);
    }

    public static int hash(Object o1, Object o2, Object o3) {
        return Maths.hash(o1, o2) * 1539836845 + Maths.hash(o3);
    }

    public static int hash(Object o1, Object o2, Object o3, Object o4) {
        return Maths.hash(o1, o2, o3) * 1539836845 + Maths.hash(o4);
    }

    public static int hash(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return Maths.hash(o1, o2, o3, o4) * 1539836845 + Maths.hash(o5);
    }

    static {
        int i;
        $VALUES = new Maths[0];
        TENS = new long[19];
        FIVES = new long[28];
        Maths.FIVES[0] = 1L;
        Maths.TENS[0] = 1L;
        for (i = 1; i < TENS.length; ++i) {
            Maths.TENS[i] = 10L * TENS[i - 1];
        }
        for (i = 1; i < FIVES.length; ++i) {
            Maths.FIVES[i] = 5L * FIVES[i - 1];
        }
    }
}

