/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.directory.sql.SQLDirectory;

public class SQLQueryBuilder
extends DefaultQueryVisitor {
    protected final SQLDirectory directory;
    public final StringBuilder clause = new StringBuilder();
    public final List<ColumnAndValue> params = new ArrayList<ColumnAndValue>();
    protected Column visitedColumn;

    public SQLQueryBuilder(SQLDirectory directory) {
        this.directory = directory;
    }

    public void visitMultiExpression(MultiExpression node) {
        if (node.predicates.isEmpty()) {
            return;
        }
        this.clause.append('(');
        Iterator it = node.predicates.iterator();
        while (it.hasNext()) {
            ((Predicate)it.next()).accept((IVisitor)this);
            if (!it.hasNext()) continue;
            node.operator.accept((IVisitor)this);
        }
        this.clause.append(')');
    }

    public void visitExpression(Expression node) {
        this.clause.append('(');
        Operand lvalue = node.lvalue;
        Operand rvalue = node.rvalue;
        Column column = null;
        if (lvalue instanceof Reference) {
            Reference ref = (Reference)lvalue;
            if (ref.cast != null) {
                throw new QueryParseException("Cannot use cast: " + node);
            }
            column = this.getColumn(ref.name);
            Operator op = node.operator;
            if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
                this.visitExpressionBetween(column, op, (LiteralList)rvalue);
            } else if (op == Operator.LIKE || op == Operator.NOTLIKE) {
                this.visitExpressionLike(column, op, rvalue);
            } else if (op == Operator.ILIKE || op == Operator.NOTILIKE) {
                this.visitExpressionILike(column, op, rvalue);
            } else {
                this.visitExpression(column, op, rvalue);
            }
        } else {
            super.visitExpression(node);
        }
        this.clause.append(')');
    }

    protected void visitExpressionBetween(Column column, Operator op, LiteralList list) {
        this.visitColumn(column);
        op.accept((IVisitor)this);
        ((Literal)list.get(0)).accept((IVisitor)this);
        this.clause.append(" AND ");
        ((Literal)list.get(1)).accept((IVisitor)this);
    }

    protected void visitExpressionLike(Column column, Operator op, Operand rvalue) {
        this.visitExpression(column, op, rvalue);
        this.addLikeEscaping();
    }

    protected void visitExpressionILike(Column column, Operator op, Operand rvalue) {
        if (this.directory.getDialect().supportsIlike()) {
            this.visitExpression(column, op, rvalue);
        } else {
            this.clause.append("LOWER(");
            this.visitColumn(column);
            this.clause.append(") ");
            if (op == Operator.NOTILIKE) {
                this.clause.append("NOT ");
            }
            this.clause.append("LIKE");
            this.clause.append(" LOWER(");
            rvalue.accept((IVisitor)this);
            this.clause.append(")");
            this.addLikeEscaping();
        }
    }

    protected void addLikeEscaping() {
        String escape = this.directory.getDialect().getLikeEscaping();
        if (escape != null) {
            this.clause.append(escape);
        }
    }

    protected void visitExpression(Column column, Operator op, Operand rvalue) {
        this.visitColumn(column);
        if (op == Operator.EQ || op == Operator.NOTEQ) {
            if (column.getType().spec == ColumnSpec.BOOLEAN) {
                rvalue = this.getBooleanLiteral(rvalue);
            }
            if (this.directory.getDialect().hasNullEmptyString() && rvalue instanceof StringLiteral && ((StringLiteral)rvalue).value.isEmpty()) {
                op = op == Operator.EQ ? Operator.ISNULL : Operator.ISNOTNULL;
                rvalue = null;
            }
        }
        op.accept((IVisitor)this);
        if (rvalue != null) {
            rvalue.accept((IVisitor)this);
        }
    }

    public void visitOperator(Operator node) {
        if (node != Operator.NOT) {
            this.clause.append(' ');
        }
        this.clause.append(node.toString());
        this.clause.append(' ');
    }

    public void visitReference(Reference node) {
        this.visitColumn(this.getColumn(node.name));
    }

    protected void visitColumn(Column column) {
        this.visitedColumn = column;
        this.clause.append(column.getQuotedName());
    }

    public void visitLiteralList(LiteralList node) {
        this.clause.append('(');
        Iterator it = node.iterator();
        while (it.hasNext()) {
            ((Literal)it.next()).accept((IVisitor)this);
            if (!it.hasNext()) continue;
            this.clause.append(", ");
        }
        this.clause.append(')');
    }

    public void visitDateLiteral(DateLiteral node) {
        this.clause.append('?');
        if (node.onlyDate) {
            this.params.add(new ColumnAndValue(this.visitedColumn, node.toSqlDate()));
        } else {
            this.params.add(new ColumnAndValue(this.visitedColumn, node.toCalendar()));
        }
    }

    public void visitStringLiteral(StringLiteral node) {
        this.clause.append('?');
        this.params.add(new ColumnAndValue(this.visitedColumn, (Serializable)((Object)node.value)));
    }

    public void visitDoubleLiteral(DoubleLiteral node) {
        this.clause.append('?');
        this.params.add(new ColumnAndValue(this.visitedColumn, Double.valueOf(node.value)));
    }

    public void visitIntegerLiteral(IntegerLiteral node) {
        this.clause.append('?');
        this.params.add(new ColumnAndValue(this.visitedColumn, Long.valueOf(node.value)));
    }

    public void visitBooleanLiteral(BooleanLiteral node) {
        this.clause.append('?');
        this.params.add(new ColumnAndValue(this.visitedColumn, Boolean.valueOf(node.value)));
    }

    public void visitFunction(Function node) {
        throw new QueryParseException("Function not supported" + node);
    }

    protected Column getColumn(String name) {
        Column column = this.directory.getTable().getColumn(name);
        if (column == null) {
            throw new QueryParseException("No column: " + name + " for directory: " + this.directory.getName());
        }
        return column;
    }

    protected Operand getBooleanLiteral(Operand rvalue) {
        long v;
        if (rvalue instanceof BooleanLiteral) {
            return rvalue;
        }
        if (!(rvalue instanceof IntegerLiteral) || (v = ((IntegerLiteral)rvalue).value) != 0L && v != 1L) {
            throw new QueryParseException("Boolean expressions require boolean or literal 0 or 1 as right argument");
        }
        return new BooleanLiteral(v == 1L);
    }

    public static class ColumnAndValue {
        public final Column column;
        public final Serializable value;

        public ColumnAndValue(Column column, Serializable value) {
            this.column = column;
            this.value = value;
        }

        public Column getColumn() {
            return this.column;
        }

        public Serializable getValue() {
            return this.value;
        }
    }
}

