/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.login.tokenauth;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.tokenauth.io.AuthenticationToken;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="token")
@Produces(value={"application/json"})
public class AuthenticationTokensObject
extends AbstractResource<ResourceTypeImpl> {
    private TokenAuthenticationService service;

    protected void initialize(Object ... args) {
        this.service = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
    }

    @GET
    public List<AuthenticationToken> getTokens(@QueryParam(value="application") String applicationName) {
        DocumentModelList tokens = this.service.getTokenBindings(this.getCurrentUser().getName(), applicationName);
        return tokens.stream().map(this::asAuthenticationToken).collect(Collectors.toList());
    }

    @POST
    public Response createToken(@QueryParam(value="application") String applicationName, @QueryParam(value="deviceId") String deviceId, @QueryParam(value="deviceDescription") String deviceDescription, @QueryParam(value="permission") String permission) {
        String username = this.getCurrentUser().getName();
        String token = this.service.acquireToken(username, applicationName, deviceId, deviceDescription, permission);
        return Response.ok((Object)token).status(Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="{token}")
    public void deleteToken(@PathParam(value="token") String tokenId) {
        if (tokenId == null) {
            return;
        }
        this.service.revokeToken(tokenId);
    }

    private NuxeoPrincipal getCurrentUser() {
        return this.getContext().getCoreSession().getPrincipal();
    }

    private AuthenticationToken asAuthenticationToken(DocumentModel entry) {
        Map props = entry.getProperties("authtoken");
        AuthenticationToken token = new AuthenticationToken((String)props.get("token"), (String)props.get("userName"), (String)props.get("applicationName"), (String)props.get("deviceId"), (String)props.get("deviceDescription"), (String)props.get("permission"));
        token.setCreationDate((Calendar)props.get("creationDate"));
        return token;
    }
}

