/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.factories;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.platform.content.template.factories.SimpleTemplateBasedFactory;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;

public class SimpleTemplateBasedRootFactory
extends SimpleTemplateBasedFactory {
    @Override
    public void createContentStructure(DocumentModel eventDoc) {
        this.initSession(eventDoc);
        boolean initRootAcl = this.shouldInitAcl(eventDoc);
        for (TemplateItemDescriptor item : this.template) {
            if (!this.shouldCreateDocument(eventDoc.getId(), item.getId(), item.getTypeName())) continue;
            Object itemPath = eventDoc.getPathAsString();
            if (item.getPath() != null) {
                itemPath = (String)itemPath + "/" + item.getPath();
            }
            DocumentModel newChild = this.session.createDocumentModel((String)itemPath, item.getId(), item.getTypeName());
            newChild.setProperty("dublincore", "title", (Object)item.getTitle());
            newChild.setProperty("dublincore", "description", (Object)item.getDescription());
            this.setProperties(item.getProperties(), newChild);
            newChild = this.session.createDocument(newChild);
            this.setAcl(item.getAcl(), newChild.getRef());
            this.session.save();
        }
        if (initRootAcl) {
            this.setAcl(this.acl, eventDoc.getRef());
        }
    }

    protected boolean shouldCreateDocument(String parentId, String childName, String childType) {
        String query = String.format("SELECT %s FROM Document WHERE %s = '%s' AND %s = '%s' AND %s = '%s'", "ecm:uuid", "ecm:parentId", parentId, "ecm:name", childName, "ecm:primaryType", childType);
        try (IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
            boolean bl = !it.iterator().hasNext();
            return bl;
        }
    }

    protected boolean shouldInitAcl(DocumentModel rootDoc) {
        for (TemplateItemDescriptor item : this.template) {
            String query = String.format("SELECT %s FROM Document WHERE %s = '%s' AND %s = '%s'", "ecm:uuid", "ecm:parentId", rootDoc.getId(), "ecm:primaryType", item.getTypeName());
            IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);
            try {
                if (!it.iterator().hasNext()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                if (it == null) continue;
                it.close();
            }
        }
        return true;
    }
}

